"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskScoreToastContent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _risk_score_doc_link = require("./risk_score_doc_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledButton = (0, _styledComponents.default)(_eui.EuiButton)`
  float: right;
`;
const useRiskScoreToastContent = riskScoreEntity => {
  const renderDocLink = (0, _react.useCallback)(message => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, message, " ", /*#__PURE__*/_react.default.createElement(_risk_score_doc_link.RiskScoreDocLink, {
    riskScoreEntity: riskScoreEntity
  })), [riskScoreEntity]);
  const renderDashboardLink = (0, _react.useCallback)((message, targetUrl) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, message, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(StyledButton, {
    href: targetUrl,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.risk_score.toast.viewDashboard",
    defaultMessage: "View dashboard"
  }))), []);
  const renderLinks = (0, _react.useMemo)(() => ({
    renderDocLink,
    renderDashboardLink
  }), [renderDashboardLink, renderDocLink]);
  return renderLinks;
};
exports.useRiskScoreToastContent = useRiskScoreToastContent;