"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreDocLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _search_strategy = require("../../../../../common/search_strategy");
var _translations = require("../../../../overview/components/entity_analytics/risk_score/translations");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLearnMoreLinkForEntity = riskScoreEntity => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const entityAnalyticsLinks = docLinks.links.securitySolution.entityAnalytics;
  return (0, _react.useMemo)(() => {
    if (!riskScoreEntity) {
      return entityAnalyticsLinks.entityRiskScoring;
    }
    if (riskScoreEntity === _search_strategy.RiskScoreEntity.user) {
      return entityAnalyticsLinks.userRiskScore;
    }
    return entityAnalyticsLinks.hostRiskScore;
  }, [riskScoreEntity, entityAnalyticsLinks]);
};
const RiskScoreDocLinkComponent = ({
  riskScoreEntity,
  title
}) => {
  const learnMoreLink = useLearnMoreLinkForEntity(riskScoreEntity);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    rel: "noopener nofollow noreferrer",
    href: learnMoreLink
  }, title ? title : (0, _translations.LEARN_MORE)(riskScoreEntity));
};
const RiskScoreDocLink = /*#__PURE__*/_react.default.memo(RiskScoreDocLinkComponent);
exports.RiskScoreDocLink = RiskScoreDocLink;
RiskScoreDocLink.displayName = 'RiskScoreDocLink';