"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRulePreviewColumns = exports.getColumns = exports.eventRenderedViewColumns = exports.assigneesColumn = void 0;
var _default_headers = require("../../../timelines/components/timeline/body/column_headers/default_headers");
var _constants = require("../../../timelines/components/timeline/body/constants");
var i18n = _interopRequireWildcard(require("../../components/alerts_table/translations"));
var _translations2 = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assigneesColumn = {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  displayAsText: i18n.ALERTS_HEADERS_ASSIGNEES,
  id: 'kibana.alert.workflow_assignee_ids',
  initialWidth: _constants.DEFAULT_DATE_COLUMN_MIN_WIDTH
};
exports.assigneesColumn = assigneesColumn;
const getBaseColumns = license => {
  var _license$isPlatinumPl, _license$isPlatinumPl2;
  const isPlatinumPlus = (_license$isPlatinumPl = license === null || license === void 0 ? void 0 : (_license$isPlatinumPl2 = license.isPlatinumPlus) === null || _license$isPlatinumPl2 === void 0 ? void 0 : _license$isPlatinumPl2.call(license)) !== null && _license$isPlatinumPl !== void 0 ? _license$isPlatinumPl : false;
  return [{
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    displayAsText: i18n.ALERTS_HEADERS_SEVERITY,
    id: 'kibana.alert.severity',
    initialWidth: 105
  }, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    displayAsText: i18n.ALERTS_HEADERS_RISK_SCORE,
    id: 'kibana.alert.risk_score',
    initialWidth: 100
  }, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    displayAsText: i18n.ALERTS_HEADERS_REASON,
    id: 'kibana.alert.reason',
    initialWidth: 450
  }, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: 'host.name'
  }, isPlatinumPlus ? {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: 'host.risk.calculated_level'
  } : null, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: 'user.name'
  }, isPlatinumPlus ? {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: 'user.risk.calculated_level'
  } : null, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: 'process.name'
  }, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: 'file.name'
  }, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: 'source.ip'
  }, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: 'destination.ip'
  }].filter(column => column != null);
};

/**
 * columns implements a subset of `EuiDataGrid`'s `EuiDataGridColumn` interface,
 * plus additional TGrid column properties
 */
const getColumns = license => [{
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: '@timestamp',
  initialWidth: _constants.DEFAULT_DATE_COLUMN_MIN_WIDTH + 10
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  displayAsText: i18n.ALERTS_HEADERS_RULE,
  id: 'kibana.alert.rule.name',
  initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH,
  linkField: 'kibana.alert.rule.uuid'
}, assigneesColumn, ...getBaseColumns(license)];
exports.getColumns = getColumns;
const getRulePreviewColumns = license => [{
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'kibana.alert.original_time',
  initialWidth: _constants.DEFAULT_DATE_COLUMN_MIN_WIDTH + 10
}, ...getBaseColumns(license)];
exports.getRulePreviewColumns = getRulePreviewColumns;
const eventRenderedViewColumns = [{
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: '@timestamp',
  displayAsText: i18n.EVENT_RENDERED_VIEW_COLUMNS.timestamp,
  initialWidth: _translations2.DEFAULT_TABLE_DATE_COLUMN_MIN_WIDTH + 50,
  actions: false,
  isExpandable: false,
  isResizable: false
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  displayAsText: i18n.EVENT_RENDERED_VIEW_COLUMNS.rule,
  id: 'kibana.alert.rule.name',
  initialWidth: _translations2.DEFAULT_TABLE_COLUMN_MIN_WIDTH + 50,
  linkField: 'kibana.alert.rule.uuid',
  actions: false,
  isExpandable: false,
  isResizable: false
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'eventSummary',
  displayAsText: i18n.EVENT_RENDERED_VIEW_COLUMNS.eventSummary,
  actions: false,
  isExpandable: false,
  isResizable: false
}];
exports.eventRenderedViewColumns = eventRenderedViewColumns;