"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _shared_imports = require("../../../../shared_imports");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELD_COMBO_BOX_WIDTH = 410;
const OperatorWrapper = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  align-self: center;
`;
const fieldDescribedByIds = ['detectionEngineStepDefineRuleThresholdField'];
const valueDescribedByIds = ['detectionEngineStepDefineRuleThresholdValue'];
const cardinalityFieldDescribedByIds = ['detectionEngineStepDefineRuleThresholdCardinalityField'];
const cardinalityValueDescribedByIds = ['detectionEngineStepDefineRuleThresholdCardinalityValue'];
const ThresholdInputComponent = ({
  thresholdField,
  thresholdValue,
  browserFields,
  thresholdCardinalityField,
  thresholdCardinalityValue
}) => {
  const fieldEuiFieldProps = (0, _react.useMemo)(() => ({
    fullWidth: true,
    noSuggestions: false,
    options: browserFields.map(field => ({
      label: field.name
    })),
    placeholder: _translations.THRESHOLD_FIELD_PLACEHOLDER,
    onCreateOption: undefined,
    style: {
      width: `${FIELD_COMBO_BOX_WIDTH}px`
    }
  }), [browserFields]);
  const cardinalityFieldEuiProps = (0, _react.useMemo)(() => ({
    fullWidth: true,
    noSuggestions: false,
    options: browserFields.map(field => ({
      label: field.name
    })),
    placeholder: _translations.THRESHOLD_FIELD_PLACEHOLDER,
    onCreateOption: undefined,
    style: {
      width: `${FIELD_COMBO_BOX_WIDTH}px`
    },
    singleSelection: {
      asPlainText: true
    }
  }), [browserFields]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    style: {
      marginLeft: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Field, {
    field: thresholdField,
    idAria: fieldDescribedByIds[0],
    "data-test-subj": fieldDescribedByIds[0],
    describedByIds: fieldDescribedByIds,
    type: thresholdField.type,
    euiFieldProps: fieldEuiFieldProps
  })), /*#__PURE__*/_react.default.createElement(OperatorWrapper, {
    grow: false
  }, '>='), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Field, {
    field: thresholdValue,
    idAria: valueDescribedByIds[0],
    "data-test-subj": valueDescribedByIds[0],
    describedByIds: valueDescribedByIds,
    type: thresholdValue.type
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Field, {
    field: thresholdCardinalityField,
    idAria: cardinalityFieldDescribedByIds[0],
    "data-test-subj": cardinalityFieldDescribedByIds[0],
    describedByIds: cardinalityFieldDescribedByIds,
    type: thresholdCardinalityField.type,
    euiFieldProps: cardinalityFieldEuiProps
  })), /*#__PURE__*/_react.default.createElement(OperatorWrapper, {
    grow: false
  }, '>='), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Field, {
    field: thresholdCardinalityValue,
    idAria: cardinalityValueDescribedByIds[0],
    "data-test-subj": cardinalityValueDescribedByIds[0],
    describedByIds: cardinalityValueDescribedByIds,
    type: thresholdCardinalityValue.type
  }))));
};
const ThresholdInput = /*#__PURE__*/_react.default.memo(ThresholdInputComponent);
exports.ThresholdInput = ThresholdInput;