"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSavedQueryCheckboxLabelWithoutName = exports.getSavedQueryCheckboxLabel = exports.getEnableThresholdSuppressionLabel = exports.THRESHOLD_SUPPRESSION_PER_RULE_EXECUTION_WARNING = exports.THREAT_MATCH_REQUIRED = exports.THREAT_MATCH_INDEX_HELPER_TEXT = exports.THREAT_MATCH_EMPTIES = exports.SOURCE = exports.SAVED_QUERY_FORM_ROW_LABEL = exports.RULE_PREVIEW_TITLE = exports.RESET_DEFAULT_INDEX = exports.QUERY_BAR_LABEL = exports.ML_JOB_SELECT_PLACEHOLDER_TEXT = exports.INVALID_CUSTOM_QUERY = exports.INDEX_HELPER_TEXT = exports.IMPORT_TIMELINE_QUERY = exports.ESQL_QUERY_REQUIRED = exports.ESQL_QUERY = exports.EQL_QUERY_REQUIRED = exports.EQL_QUERY_BAR_LABEL = exports.DATA_SOURCE_GUIDE_TITLE = exports.DATA_SOURCE_GUIDE_SUB_TITLE = exports.DATA_SOURCE_GUIDE_CONTENT = exports.CUSTOM_QUERY_REQUIRED = exports.ALERT_SUPPRESSION_PER_TIME_PERIOD = exports.ALERT_SUPPRESSION_PER_RULE_EXECUTION = exports.ALERT_SUPPRESSION_MISSING_FIELDS_SUPPRESS_OPTION = exports.ALERT_SUPPRESSION_MISSING_FIELDS_FORM_ROW_LABEL = exports.ALERT_SUPPRESSION_MISSING_FIELDS_DO_NOT_SUPPRESS_OPTION = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CUSTOM_QUERY_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.customQueryFieldRequiredError', {
  defaultMessage: 'A custom query is required.'
});
exports.CUSTOM_QUERY_REQUIRED = CUSTOM_QUERY_REQUIRED;
const EQL_QUERY_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.eqlQueryFieldRequiredError', {
  defaultMessage: 'An EQL query is required.'
});
exports.EQL_QUERY_REQUIRED = EQL_QUERY_REQUIRED;
const ESQL_QUERY_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.esqlQueryFieldRequiredError', {
  defaultMessage: 'An ES|QL query is required.'
});
exports.ESQL_QUERY_REQUIRED = ESQL_QUERY_REQUIRED;
const INVALID_CUSTOM_QUERY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.customQueryFieldInvalidError', {
  defaultMessage: 'The KQL is invalid'
});
exports.INVALID_CUSTOM_QUERY = INVALID_CUSTOM_QUERY;
const INDEX_HELPER_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.indicesHelperDescription', {
  defaultMessage: 'Enter the pattern of Elasticsearch indices where you would like this rule to run. By default, these will include index patterns defined in Security Solution advanced settings.'
});
exports.INDEX_HELPER_TEXT = INDEX_HELPER_TEXT;
const RESET_DEFAULT_INDEX = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.resetDefaultIndicesButton', {
  defaultMessage: 'Reset to default index patterns'
});
exports.RESET_DEFAULT_INDEX = RESET_DEFAULT_INDEX;
const IMPORT_TIMELINE_QUERY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.importTimelineQueryButton', {
  defaultMessage: 'Import query from saved timeline'
});
exports.IMPORT_TIMELINE_QUERY = IMPORT_TIMELINE_QUERY;
const ML_JOB_SELECT_PLACEHOLDER_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.mlJobSelectPlaceholderText', {
  defaultMessage: 'Select a job'
});
exports.ML_JOB_SELECT_PLACEHOLDER_TEXT = ML_JOB_SELECT_PLACEHOLDER_TEXT;
const QUERY_BAR_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldQuerBarLabel', {
  defaultMessage: 'Custom query'
});
exports.QUERY_BAR_LABEL = QUERY_BAR_LABEL;
const EQL_QUERY_BAR_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.EqlQueryBarLabel', {
  defaultMessage: 'EQL query'
});
exports.EQL_QUERY_BAR_LABEL = EQL_QUERY_BAR_LABEL;
const SAVED_QUERY_FORM_ROW_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.SavedQueryFormRowLabel', {
  defaultMessage: 'Saved query'
});
exports.SAVED_QUERY_FORM_ROW_LABEL = SAVED_QUERY_FORM_ROW_LABEL;
const getSavedQueryCheckboxLabel = savedQueryName => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldShouldLoadQueryDynamicallyLabel', {
  defaultMessage: 'Load saved query "{savedQueryName}" dynamically on each rule execution',
  values: {
    savedQueryName
  }
});
exports.getSavedQueryCheckboxLabel = getSavedQueryCheckboxLabel;
const getSavedQueryCheckboxLabelWithoutName = () => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldShouldLoadQueryDynamicallyLabelWithoutName', {
  defaultMessage: 'Load saved query dynamically on each rule execution'
});
exports.getSavedQueryCheckboxLabelWithoutName = getSavedQueryCheckboxLabelWithoutName;
const THREAT_MATCH_INDEX_HELPER_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.threatMatchingIcesHelperDescription', {
  defaultMessage: 'Select threat indices'
});
exports.THREAT_MATCH_INDEX_HELPER_TEXT = THREAT_MATCH_INDEX_HELPER_TEXT;
const THREAT_MATCH_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.customThreatQueryFieldRequiredError', {
  defaultMessage: 'At least one indicator match is required.'
});
exports.THREAT_MATCH_REQUIRED = THREAT_MATCH_REQUIRED;
const THREAT_MATCH_EMPTIES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.customThreatQueryFieldRequiredEmptyError', {
  defaultMessage: 'All matches require both a field and threat index field.'
});
exports.THREAT_MATCH_EMPTIES = THREAT_MATCH_EMPTIES;
const SOURCE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.source', {
  defaultMessage: 'Source'
});
exports.SOURCE = SOURCE;
const DATA_SOURCE_GUIDE_SUB_TITLE = _i18n.i18n.translate('xpack.securitySolution.detections.dataSource.popover.title', {
  defaultMessage: 'Select a data source'
});
exports.DATA_SOURCE_GUIDE_SUB_TITLE = DATA_SOURCE_GUIDE_SUB_TITLE;
const DATA_SOURCE_GUIDE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detections.dataSource.popover.subTitle', {
  defaultMessage: 'Data sources'
});
exports.DATA_SOURCE_GUIDE_TITLE = DATA_SOURCE_GUIDE_TITLE;
const DATA_SOURCE_GUIDE_CONTENT = _i18n.i18n.translate('xpack.securitySolution.detections.dataSource.popover.content', {
  defaultMessage: 'Rules can now query index patterns or data views.'
});
exports.DATA_SOURCE_GUIDE_CONTENT = DATA_SOURCE_GUIDE_CONTENT;
const RULE_PREVIEW_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.rulePreviewTitle', {
  defaultMessage: 'Rule Preview'
});
exports.RULE_PREVIEW_TITLE = RULE_PREVIEW_TITLE;
const ALERT_SUPPRESSION_MISSING_FIELDS_FORM_ROW_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionMissingFieldsLabel', {
  defaultMessage: 'If a suppression field is missing'
});
exports.ALERT_SUPPRESSION_MISSING_FIELDS_FORM_ROW_LABEL = ALERT_SUPPRESSION_MISSING_FIELDS_FORM_ROW_LABEL;
const ALERT_SUPPRESSION_MISSING_FIELDS_SUPPRESS_OPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionMissingFieldsSuppressLabel', {
  defaultMessage: 'Suppress and group alerts for events with missing fields'
});
exports.ALERT_SUPPRESSION_MISSING_FIELDS_SUPPRESS_OPTION = ALERT_SUPPRESSION_MISSING_FIELDS_SUPPRESS_OPTION;
const ALERT_SUPPRESSION_MISSING_FIELDS_DO_NOT_SUPPRESS_OPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionMissingFieldsDoNotSuppressLabel', {
  defaultMessage: 'Do not suppress alerts for events with missing fields'
});
exports.ALERT_SUPPRESSION_MISSING_FIELDS_DO_NOT_SUPPRESS_OPTION = ALERT_SUPPRESSION_MISSING_FIELDS_DO_NOT_SUPPRESS_OPTION;
const ESQL_QUERY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.esqlQueryLabel', {
  defaultMessage: 'ES|QL query'
});
exports.ESQL_QUERY = ESQL_QUERY;
const ALERT_SUPPRESSION_PER_RULE_EXECUTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionOptions.perRuleExecutionLabel', {
  defaultMessage: 'Per rule execution'
});
exports.ALERT_SUPPRESSION_PER_RULE_EXECUTION = ALERT_SUPPRESSION_PER_RULE_EXECUTION;
const ALERT_SUPPRESSION_PER_TIME_PERIOD = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionOptions.perTimePeriodLabel', {
  defaultMessage: 'Per time period'
});
exports.ALERT_SUPPRESSION_PER_TIME_PERIOD = ALERT_SUPPRESSION_PER_TIME_PERIOD;
const THRESHOLD_SUPPRESSION_PER_RULE_EXECUTION_WARNING = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.Su.perRuleExecutionWarning', {
  defaultMessage: 'Per rule execution option is not available for Threshold rule type'
});
exports.THRESHOLD_SUPPRESSION_PER_RULE_EXECUTION_WARNING = THRESHOLD_SUPPRESSION_PER_RULE_EXECUTION_WARNING;
const getEnableThresholdSuppressionLabel = fields => fields !== null && fields !== void 0 && fields.length ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.createRule.stepDefineRule.enableThresholdSuppressionForFieldsLabel",
  defaultMessage: "Suppress alerts by selected fields: {fieldsString} (Technical Preview)",
  values: {
    fieldsString: /*#__PURE__*/_react.default.createElement("strong", null, fields.join(', '))
  }
}) : _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.enableThresholdSuppressionLabel', {
  defaultMessage: 'Suppress alerts (Technical Preview)'
});
exports.getEnableThresholdSuppressionLabel = getEnableThresholdSuppressionLabel;