"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDefineRuleReadOnly = exports.StepDefineRule = exports.MyLabelButton = void 0;
exports.aggregatableFields = aggregatableFields;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _i18nReact = require("@kbn/i18n-react");
var _use_set_field_value_cb = require("../../../../common/utils/use_set_field_value_cb");
var _use_rule_from_timeline = require("../../../containers/detection_engine/rules/use_rule_from_timeline");
var _helpers = require("../../../../../common/machine_learning/helpers");
var _has_ml_admin_permissions = require("../../../../../common/machine_learning/has_ml_admin_permissions");
var _has_ml_license = require("../../../../../common/machine_learning/has_ml_license");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _helpers2 = require("../../../../detection_engine/rule_creation_ui/pages/rule_creation/helpers");
var _types = require("../../../pages/detection_engine/rules/types");
var _description_step = require("../description_step");
var _query_bar = require("../query_bar");
var _select_rule_type = require("../select_rule_type");
var _anomaly_threshold_slider = require("../anomaly_threshold_slider");
var _ml_job_select = require("../ml_job_select");
var _pick_timeline = require("../pick_timeline");
var _step_content_wrapper = require("../step_content_wrapper");
var _threshold_input = require("../threshold_input");
var _suppression_info_icon = require("../suppression_info_icon");
var _esql_info_icon = require("../../../../detection_engine/rule_creation/components/esql_info_icon");
var _shared_imports = require("../../../../shared_imports");
var _schema = require("./schema");
var _utils = require("./utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils2 = require("../../../../../common/detection_engine/utils");
var _eql_query_bar = require("../eql_query_bar");
var _data_view_selector = require("../data_view_selector");
var _threatmatch_input = require("../threatmatch_input");
var _source = require("../../../../common/containers/source");
var _new_terms_fields = require("../new_terms_fields");
var _schedule_item_form = require("../schedule_item_form");
var _doc_link = require("../../../../common/components/links_to_docs/doc_link");
var _utils3 = require("../../../pages/detection_engine/rules/utils");
var _multi_select_fields = require("../multi_select_fields");
var _use_license = require("../../../../common/hooks/use_license");
var _rule_schema = require("../../../../../common/api/detection_engine/model/rule_schema");
var _duration_input = require("../duration_input");
var _constants = require("../../../../../common/detection_engine/constants");
var _use_upselling = require("../../../../common/hooks/use_upselling");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const StyledVisibleContainer = _styledComponents.default.div`
  display: ${props => props.isVisible ? 'block' : 'none'};
`;
const MyLabelButton = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  height: 18px;
  font-size: 12px;

  .euiIcon {
    width: 14px;
    height: 14px;
  }
`;
exports.MyLabelButton = MyLabelButton;
MyLabelButton.defaultProps = {
  flush: 'right'
};
const RuleTypeEuiFormRow = (0, _styledComponents.default)(_eui.EuiFormRow).attrs(({
  $isVisible
}) => ({
  style: {
    display: $isVisible ? 'flex' : 'none'
  }
}))``;
const IntendedRuleTypeEuiFormRow = (0, _styledComponents.default)(RuleTypeEuiFormRow)`
  ${({
  theme
}) => `padding-left: ${theme.eui.euiSizeXL};`}
`;
const StepDefineRuleComponent = ({
  isLoading,
  isUpdateView = false,
  kibanaDataViews,
  indicesConfig,
  threatIndicesConfig,
  defaultSavedQuery,
  form,
  optionsSelected,
  setOptionsSelected,
  indexPattern,
  isIndexPatternLoading,
  browserFields,
  isQueryBarValid,
  setIsQueryBarValid,
  setIsThreatQueryBarValid,
  ruleType,
  index,
  threatIndex,
  groupByFields,
  dataSourceType,
  shouldLoadQueryDynamically,
  queryBarTitle,
  queryBarSavedId,
  thresholdFields,
  enableThresholdSuppression
}) => {
  const mlCapabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const [openTimelineSearch, setOpenTimelineSearch] = (0, _react.useState)(false);
  const [indexModified, setIndexModified] = (0, _react.useState)(false);
  const [threatIndexModified, setThreatIndexModified] = (0, _react.useState)(false);
  const license = (0, _use_license.useLicense)();
  const esqlQueryRef = (0, _react.useRef)(undefined);
  const isAlertSuppressionLicenseValid = license.isAtLeast(_constants.MINIMUM_LICENSE_FOR_SUPPRESSION);
  const isThresholdRule = (0, _utils2.isThresholdRule)(ruleType);
  const alertSuppressionUpsellingMessage = (0, _use_upselling.useUpsellingMessage)('alert_suppression_rule_form');
  const {
    getFields,
    reset,
    setFieldValue
  } = form;
  const setRuleTypeCallback = (0, _use_set_field_value_cb.useSetFieldValueWithCallback)({
    field: 'ruleType',
    value: ruleType,
    setFieldValue
  });
  const handleSetRuleFromTimeline = (0, _react.useCallback)(({
    index: timelineIndex,
    queryBar: timelineQueryBar,
    eqlOptions
  }) => {
    const setQuery = () => {
      setFieldValue('index', timelineIndex);
      setFieldValue('queryBar', timelineQueryBar);
    };
    if (timelineQueryBar.query.language === 'eql') {
      setRuleTypeCallback('eql', setQuery);
      setOptionsSelected(prevOptions => ({
        ...prevOptions,
        ...(eqlOptions != null ? eqlOptions : {})
      }));
    } else {
      setQuery();
    }
  }, [setFieldValue, setRuleTypeCallback, setOptionsSelected]);
  const {
    onOpenTimeline,
    loading: timelineQueryLoading
  } = (0, _use_rule_from_timeline.useRuleFromTimeline)(handleSetRuleFromTimeline);

  // if 'index' is selected, use these browser fields
  // otherwise use the dataview browserfields
  const previousRuleType = (0, _usePrevious.default)(ruleType);

  // Callback for when user toggles between Data Views and Index Patterns
  const onChangeDataSource = (0, _react.useCallback)(optionId => {
    form.setFieldValue('dataSourceType', optionId);
    form.getFields().index.reset({
      resetValue: false
    });
    form.getFields().dataViewId.reset({
      resetValue: false
    });
  }, [form]);
  const [aggFields, setAggregatableFields] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    const {
      fields
    } = indexPattern;
    /**
     * Typecasting to BrowserField because fields is
     * typed as DataViewFieldBase[] which does not have
     * the 'aggregatable' property, however the type is incorrect
     *
     * fields does contain elements with the aggregatable property.
     * We will need to determine where these types are defined and
     * figure out where the discrepency is.
     */
    setAggregatableFields(aggregatableFields(fields));
  }, [indexPattern]);
  const termsAggregationFields = (0, _react.useMemo)(() => (0, _utils.getTermsAggregationFields)(aggFields), [aggFields]);
  const [threatIndexPatternsLoading, {
    browserFields: threatBrowserFields,
    indexPatterns: threatIndexPatterns
  }] = (0, _source.useFetchIndex)(threatIndex);

  // reset form when rule type changes
  (0, _react.useEffect)(() => {
    reset({
      resetValues: false
    });
  }, [reset, ruleType]);
  (0, _react.useEffect)(() => {
    setIndexModified(!(0, _lodash.isEqual)(index, indicesConfig));
  }, [index, indicesConfig]);
  (0, _react.useEffect)(() => {
    setThreatIndexModified(!(0, _lodash.isEqual)(threatIndex, threatIndicesConfig));
  }, [threatIndex, threatIndicesConfig]);

  /**
   * When the user changes rule type to or from "threat_match" this will modify the
   * default "Custom query" string to either:
   *   * from '' to '*:*' if the type is switched to "threat_match"
   *   * from '*:*' back to '' if the type is switched back from "threat_match" to another one
   */
  (0, _react.useEffect)(() => {
    const {
      queryBar: currentQuery
    } = getFields();
    if (currentQuery == null) {
      return;
    }

    // NOTE: Below this code does two things that are worth commenting.

    // 1. If the user enters some text in the "Custom query" form field, we want
    // to keep it even if the user switched to another rule type. So we want to
    // be able to figure out if the field has been modified.
    // - The forms library provides properties (isPristine, isModified, isDirty)
    //   for that but they can't be used in our case: their values can be reset
    //   if you go to step 2 and then back to step 1 or the form is reset in another way.
    // - That's why we compare the actual value of the field with default ones.
    //   NOTE: It's important to do a deep object comparison by value.
    //   Don't do it by reference because the forms lib can change it internally.

    // 2. We call currentQuery.reset() in both cases to not trigger validation errors
    // as the user has not entered data into those areas yet.

    // If the user switched rule type to "threat_match" from any other one,
    // but hasn't changed the custom query used for normal rules (''),
    // we reset the custom query to the default used for "threat_match" rules ('*:*').
    if ((0, _utils2.isThreatMatchRule)(ruleType) && !(0, _utils2.isThreatMatchRule)(previousRuleType)) {
      if ((0, _lodash.isEqual)(currentQuery.value, _utils3.defaultCustomQuery.forNormalRules)) {
        currentQuery.reset({
          defaultValue: _utils3.defaultCustomQuery.forThreatMatchRules
        });
        return;
      }
    }

    // If the user switched rule type from "threat_match" to any other one,
    // but hasn't changed the custom query used for "threat_match" rules ('*:*'),
    // we reset the custom query to another default value ('').
    if (!(0, _utils2.isThreatMatchRule)(ruleType) && (0, _utils2.isThreatMatchRule)(previousRuleType)) {
      if ((0, _lodash.isEqual)(currentQuery.value, _utils3.defaultCustomQuery.forThreatMatchRules)) {
        currentQuery.reset({
          defaultValue: _utils3.defaultCustomQuery.forNormalRules
        });
      }
    }
  }, [ruleType, previousRuleType, getFields]);

  /**
   * ensures when user switches between rule types, written ES|QL query is not getting lost
   * additional work is required in this code area, as currently switching to EQL will result in query lose
   * https://github.com/elastic/kibana/issues/166933
   */
  (0, _react.useEffect)(() => {
    const {
      queryBar: currentQuery
    } = getFields();
    if (currentQuery == null) {
      return;
    }
    const currentQueryValue = currentQuery.value;

    // sets ES|QL query to a default value or earlier added one, when switching to ES|QL rule type
    if ((0, _utils2.isEsqlRule)(ruleType)) {
      if (previousRuleType && !(0, _utils2.isEsqlRule)(previousRuleType)) {
        var _esqlQueryRef$current;
        currentQuery.reset({
          defaultValue: (_esqlQueryRef$current = esqlQueryRef.current) !== null && _esqlQueryRef$current !== void 0 ? _esqlQueryRef$current : _utils3.defaultCustomQuery.forEsqlRules
        });
      }
      // otherwise reset it to default values of other rule types
    } else if ((0, _utils2.isEsqlRule)(previousRuleType)) {
      var _currentQueryValue$qu;
      // sets ES|QL query value to reference, so it can be used when user switch back from one rule type to another
      if ((currentQueryValue === null || currentQueryValue === void 0 ? void 0 : (_currentQueryValue$qu = currentQueryValue.query) === null || _currentQueryValue$qu === void 0 ? void 0 : _currentQueryValue$qu.language) === 'esql') {
        esqlQueryRef.current = currentQueryValue;
      }
      const defaultValue = (0, _utils2.isThreatMatchRule)(ruleType) ? _utils3.defaultCustomQuery.forThreatMatchRules : _utils3.defaultCustomQuery.forNormalRules;
      currentQuery.reset({
        defaultValue
      });
    }
  }, [ruleType, previousRuleType, getFields]);

  /**
   * for threshold rule suppression only time interval suppression mode is available
   */
  (0, _react.useEffect)(() => {
    if (isThresholdRule) {
      form.setFieldValue('groupByRadioSelection', _types.GroupByOptions.PerTimePeriod);
    }
  }, [isThresholdRule, form]);

  // if saved query failed to load:
  // - reset shouldLoadFormDynamically to false, as non existent query cannot be used for loading and execution
  const handleSavedQueryError = (0, _react.useCallback)(() => {
    if (!isQueryBarValid) {
      form.setFieldValue('shouldLoadQueryDynamically', false);
    }
  }, [isQueryBarValid, form]);
  const handleResetIndices = (0, _react.useCallback)(() => {
    const indexField = getFields().index;
    indexField.setValue(indicesConfig);
  }, [getFields, indicesConfig]);
  const handleResetThreatIndices = (0, _react.useCallback)(() => {
    const threatIndexField = getFields().threatIndex;
    threatIndexField.setValue(threatIndicesConfig);
  }, [getFields, threatIndicesConfig]);
  const handleOpenTimelineSearch = (0, _react.useCallback)(() => {
    setOpenTimelineSearch(true);
  }, []);
  const handleCloseTimelineSearch = (0, _react.useCallback)(() => {
    setOpenTimelineSearch(false);
  }, []);
  const ThresholdInputChildren = (0, _react.useCallback)(({
    thresholdField,
    thresholdValue,
    thresholdCardinalityField,
    thresholdCardinalityValue
  }) => /*#__PURE__*/_react.default.createElement(_threshold_input.ThresholdInput, {
    browserFields: aggFields,
    thresholdField: thresholdField,
    thresholdValue: thresholdValue,
    thresholdCardinalityField: thresholdCardinalityField,
    thresholdCardinalityValue: thresholdCardinalityValue
  }), [aggFields]);
  const ThreatMatchInputChildren = (0, _react.useCallback)(({
    threatMapping
  }) => /*#__PURE__*/_react.default.createElement(_threatmatch_input.ThreatMatchInput, {
    handleResetThreatIndices: handleResetThreatIndices,
    indexPatterns: indexPattern,
    threatBrowserFields: threatBrowserFields,
    threatIndexModified: threatIndexModified,
    threatIndexPatterns: threatIndexPatterns,
    threatIndexPatternsLoading: threatIndexPatternsLoading,
    threatMapping: threatMapping,
    onValidityChange: setIsThreatQueryBarValid
  }), [handleResetThreatIndices, indexPattern, setIsThreatQueryBarValid, threatBrowserFields, threatIndexModified, threatIndexPatterns, threatIndexPatternsLoading]);

  /**
   * Component that allows selection of suppression intervals disabled:
   *  - if suppression license is not valid(i.e. less than platinum)
   *  - or for not threshold rule - when groupBy fields not selected
   */
  const isGroupByChildrenDisabled = !isAlertSuppressionLicenseValid || isThresholdRule ? false : !(groupByFields !== null && groupByFields !== void 0 && groupByFields.length);

  /**
   * Per rule execution radio option is disabled
   *  - if suppression license is not valid(i.e. less than platinum)
   *  - always disabled for threshold rule
   */
  const isPerRuleExecutionDisabled = !isAlertSuppressionLicenseValid || isThresholdRule;

  /**
   * Per time period execution radio option is disabled
   *  - if suppression license is not valid(i.e. less than platinum)
   *  - disabled for threshold rule when enabled suppression is not checked
   */
  const isPerTimePeriodDisabled = !isAlertSuppressionLicenseValid || isThresholdRule && !enableThresholdSuppression;

  /**
   * Suppression duration is disabled when
   *  - if suppression license is not valid(i.e. less than platinum)
   *  - when suppression by rule execution is selected in radio button
   *  - whe threshold suppression is not enabled and no group by fields selected
   * */
  const isDurationDisabled = !isAlertSuppressionLicenseValid || !enableThresholdSuppression && (groupByFields === null || groupByFields === void 0 ? void 0 : groupByFields.length) === 0;
  const GroupByChildren = (0, _react.useCallback)(({
    groupByRadioSelection,
    groupByDurationUnit,
    groupByDurationValue
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    disabled: isGroupByChildrenDisabled,
    idSelected: groupByRadioSelection.value,
    options: [{
      id: _types.GroupByOptions.PerRuleExecution,
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: isThresholdRule ? i18n.THRESHOLD_SUPPRESSION_PER_RULE_EXECUTION_WARNING : null
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " ", i18n.ALERT_SUPPRESSION_PER_RULE_EXECUTION)),
      disabled: isPerRuleExecutionDisabled
    }, {
      id: _types.GroupByOptions.PerTimePeriod,
      disabled: isPerTimePeriodDisabled,
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.ALERT_SUPPRESSION_PER_TIME_PERIOD, /*#__PURE__*/_react.default.createElement(_duration_input.DurationInput, {
        "data-test-subj": "alertSuppressionDurationInput",
        durationValueField: groupByDurationValue,
        durationUnitField: groupByDurationUnit
        // Suppression duration is also disabled suppression by rule execution is selected in radio button
        ,
        isDisabled: isDurationDisabled || groupByRadioSelection.value !== _types.GroupByOptions.PerTimePeriod,
        minimumValue: 1
      }))
    }],
    onChange: id => {
      groupByRadioSelection.setValue(id);
    },
    "data-test-subj": "groupByDurationOptions"
  }), [isThresholdRule, isDurationDisabled, isPerTimePeriodDisabled, isPerRuleExecutionDisabled, isGroupByChildrenDisabled]);
  const AlertSuppressionMissingFields = (0, _react.useCallback)(({
    suppressionMissingFields
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    disabled: !isAlertSuppressionLicenseValid || !groupByFields.length,
    idSelected: suppressionMissingFields.value,
    options: [{
      id: _rule_schema.AlertSuppressionMissingFieldsStrategyEnum.suppress,
      label: i18n.ALERT_SUPPRESSION_MISSING_FIELDS_SUPPRESS_OPTION
    }, {
      id: _rule_schema.AlertSuppressionMissingFieldsStrategyEnum.doNotSuppress,
      label: i18n.ALERT_SUPPRESSION_MISSING_FIELDS_DO_NOT_SUPPRESS_OPTION
    }],
    onChange: id => {
      suppressionMissingFields.setValue(id);
    },
    "data-test-subj": "suppressionMissingFieldsOptions"
  }), [isAlertSuppressionLicenseValid, groupByFields]);
  const dataViewIndexPatternToggleButtonOptions = (0, _react.useMemo)(() => [{
    id: _types.DataSourceType.IndexPatterns,
    label: _i18n.i18n.translate('xpack.securitySolution.ruleDefine.indexTypeSelect.indexPattern', {
      defaultMessage: 'Index Patterns'
    }),
    iconType: dataSourceType === _types.DataSourceType.IndexPatterns ? 'checkInCircleFilled' : 'empty',
    'data-test-subj': `rule-index-toggle-${_types.DataSourceType.IndexPatterns}`
  }, {
    id: _types.DataSourceType.DataView,
    label: _i18n.i18n.translate('xpack.securitySolution.ruleDefine.indexTypeSelect.dataView', {
      defaultMessage: 'Data View'
    }),
    iconType: dataSourceType === _types.DataSourceType.DataView ? 'checkInCircleFilled' : 'empty',
    'data-test-subj': `rule-index-toggle-${_types.DataSourceType.DataView}`
  }], [dataSourceType]);
  const DataViewSelectorMemo = (0, _react.useMemo)(() => {
    return kibanaDataViews == null || Object.keys(kibanaDataViews).length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l"
    }) : /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      key: "DataViewSelector",
      path: "dataViewId",
      component: _data_view_selector.DataViewSelector,
      componentProps: {
        kibanaDataViews
      }
    });
  }, [kibanaDataViews]);
  const DataSource = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
      label: i18n.SOURCE,
      $isVisible: true,
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      "data-test-subj": "dataViewIndexPatternButtonGroupFlexGroup"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.dataViewSelectorText1",
      defaultMessage: "Use Kibana "
    }), /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
      guidePath: "kibana",
      docPath: "data-views.html",
      linkText: "Data Views"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.dataViewSelectorText2",
      defaultMessage: " or specify individual "
    }), /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
      guidePath: "kibana",
      docPath: "index-patterns-api-create.html",
      linkText: "index patterns"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.dataViewSelectorText3",
      defaultMessage: " as your rule's data source to be searched."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
      $isVisible: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      isFullWidth: true,
      legend: "Rule index pattern or data view selector",
      "data-test-subj": "dataViewIndexPatternButtonGroup",
      idSelected: dataSourceType,
      onChange: onChangeDataSource,
      options: dataViewIndexPatternToggleButtonOptions,
      color: "primary"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StyledVisibleContainer, {
      isVisible: dataSourceType === _types.DataSourceType.DataView
    }, DataViewSelectorMemo), /*#__PURE__*/_react.default.createElement(StyledVisibleContainer, {
      isVisible: dataSourceType === _types.DataSourceType.IndexPatterns
    }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
      path: "index",
      config: {
        ...(0, _lodash.omit)(_schema.schema.index, 'label'),
        labelAppend: indexModified ? /*#__PURE__*/_react.default.createElement(MyLabelButton, {
          onClick: handleResetIndices,
          iconType: "refresh"
        }, i18n.RESET_DEFAULT_INDEX) : null
      },
      componentProps: {
        idAria: 'detectionEngineStepDefineRuleIndices',
        'data-test-subj': 'detectionEngineStepDefineRuleIndices',
        euiFieldProps: {
          fullWidth: true,
          placeholder: '',
          isDisabled: timelineQueryLoading,
          isLoading: timelineQueryLoading
        }
      }
    })))));
  }, [timelineQueryLoading, dataSourceType, onChangeDataSource, dataViewIndexPatternToggleButtonOptions, DataViewSelectorMemo, indexModified, handleResetIndices]);
  const queryBarProps = (0, _react.useMemo)(() => ({
    idAria: 'detectionEngineStepDefineRuleQueryBar',
    indexPattern,
    isDisabled: isLoading,
    isLoading,
    dataTestSubj: 'detectionEngineStepDefineRuleQueryBar',
    onValidityChange: setIsQueryBarValid
  }), [indexPattern, isLoading, setIsQueryBarValid]);
  const esqlQueryBarConfig = (0, _react.useMemo)(() => ({
    ..._schema.schema.queryBar,
    label: i18n.ESQL_QUERY,
    labelAppend: /*#__PURE__*/_react.default.createElement(_esql_info_icon.EsqlInfoIcon, null)
  }), []);
  const EsqlQueryBarMemo = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    key: "QueryBarDefineRule",
    path: "queryBar",
    config: esqlQueryBarConfig,
    component: _query_bar.QueryBarDefineRule,
    componentProps: {
      ...queryBarProps,
      dataTestSubj: 'detectionEngineStepDefineRuleEsqlQueryBar',
      idAria: 'detectionEngineStepDefineRuleEsqlQueryBar'
    }
  }), [queryBarProps, esqlQueryBarConfig]);
  const QueryBarMemo = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    key: "QueryBarDefineRule",
    path: "queryBar",
    config: {
      ..._schema.schema.queryBar,
      label: i18n.QUERY_BAR_LABEL,
      labelAppend: /*#__PURE__*/_react.default.createElement(MyLabelButton, {
        "data-test-subj": "importQueryFromSavedTimeline",
        onClick: handleOpenTimelineSearch,
        disabled: shouldLoadQueryDynamically
      }, i18n.IMPORT_TIMELINE_QUERY)
    },
    component: _query_bar.QueryBarDefineRule,
    componentProps: {
      browserFields,
      idAria: 'detectionEngineStepDefineRuleQueryBar',
      indexPattern,
      isDisabled: isLoading || shouldLoadQueryDynamically || timelineQueryLoading,
      resetToSavedQuery: shouldLoadQueryDynamically,
      isLoading: isIndexPatternLoading || timelineQueryLoading,
      dataTestSubj: 'detectionEngineStepDefineRuleQueryBar',
      openTimelineSearch,
      onValidityChange: setIsQueryBarValid,
      onCloseTimelineSearch: handleCloseTimelineSearch,
      onSavedQueryError: handleSavedQueryError,
      defaultSavedQuery,
      onOpenTimeline
    }
  }), [handleOpenTimelineSearch, shouldLoadQueryDynamically, browserFields, indexPattern, isLoading, timelineQueryLoading, isIndexPatternLoading, openTimelineSearch, setIsQueryBarValid, handleCloseTimelineSearch, handleSavedQueryError, defaultSavedQuery, onOpenTimeline]);
  const onOptionsChange = (0, _react.useCallback)((field, value) => {
    setOptionsSelected(prevOptions => ({
      ...prevOptions,
      [field]: value
    }));
  }, [setOptionsSelected]);
  const optionsData = (0, _react.useMemo)(() => (0, _lodash.isEmpty)(indexPattern.fields) ? {
    keywordFields: [],
    dateFields: [],
    nonDateFields: []
  } : {
    keywordFields: indexPattern.fields.filter(f => {
      var _f$esTypes;
      return (_f$esTypes = f.esTypes) === null || _f$esTypes === void 0 ? void 0 : _f$esTypes.includes('keyword');
    }).map(f => ({
      label: f.name
    })),
    dateFields: indexPattern.fields.filter(f => f.type === 'date').map(f => ({
      label: f.name
    })),
    nonDateFields: indexPattern.fields.filter(f => f.type !== 'date').map(f => ({
      label: f.name
    }))
  }, [indexPattern]);
  const selectRuleTypeProps = (0, _react.useMemo)(() => ({
    describedByIds: ['detectionEngineStepDefineRuleType'],
    isUpdateView,
    hasValidLicense: (0, _has_ml_license.hasMlLicense)(mlCapabilities),
    isMlAdmin: (0, _has_ml_admin_permissions.hasMlAdminPermissions)(mlCapabilities)
  }), [isUpdateView, mlCapabilities]);
  const isAlertSuppressionEnabled = (0, _utils2.isQueryRule)(ruleType) || isThresholdRule;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    addPadding: !isUpdateView
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "stepDefineRule"
  }, /*#__PURE__*/_react.default.createElement(StyledVisibleContainer, {
    isVisible: false
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "dataSourceType",
    componentProps: {
      euiFieldProps: {
        fullWidth: true,
        placeholder: ''
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "ruleType",
    component: _select_rule_type.SelectRuleType,
    componentProps: selectRuleTypeProps
  }), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: !(0, _helpers.isMlRule)(ruleType),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledVisibleContainer, {
    isVisible: !(0, _utils2.isEsqlRule)(ruleType)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), DataSource), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), (0, _utils2.isEqlRule)(ruleType) ? /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    key: "EqlQueryBar",
    path: "queryBar",
    component: _eql_query_bar.EqlQueryBar,
    componentProps: {
      optionsData,
      optionsSelected,
      isSizeOptionDisabled: true,
      onOptionsChange,
      onValidityChange: setIsQueryBarValid,
      idAria: 'detectionEngineStepDefineRuleEqlQueryBar',
      isDisabled: isLoading,
      isLoading: isIndexPatternLoading,
      indexPattern,
      showFilterBar: true,
      // isLoading: indexPatternsLoading,
      dataTestSubj: 'detectionEngineStepDefineRuleEqlQueryBar'
    },
    config: {
      ..._schema.schema.queryBar,
      label: i18n.EQL_QUERY_BAR_LABEL
    }
  }) : (0, _utils2.isEsqlRule)(ruleType) ? EsqlQueryBarMemo : QueryBarMemo)), (0, _utils2.isQueryRule)(ruleType) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    label: i18n.SAVED_QUERY_FORM_ROW_LABEL,
    $isVisible: Boolean(queryBarSavedId),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "shouldLoadQueryDynamically",
    componentProps: {
      idAria: 'detectionEngineStepDefineRuleShouldLoadQueryDynamically',
      'data-test-subj': 'detectionEngineStepDefineRuleShouldLoadQueryDynamically',
      euiFieldProps: {
        disabled: isLoading,
        label: queryBarTitle ? i18n.getSavedQueryCheckboxLabel(queryBarTitle) : i18n.getSavedQueryCheckboxLabelWithoutName()
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: (0, _helpers.isMlRule)(ruleType),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "machineLearningJobId",
    component: _ml_job_select.MlJobSelect,
    componentProps: {
      describedByIds: ['detectionEngineStepDefineRulemachineLearningJobId']
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "anomalyThreshold",
    component: _anomaly_threshold_slider.AnomalyThresholdSlider,
    componentProps: {
      describedByIds: ['detectionEngineStepDefineRuleAnomalyThreshold']
    }
  }))), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: isThresholdRule,
    "data-test-subj": "thresholdInput",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      thresholdField: {
        path: 'threshold.field'
      },
      thresholdValue: {
        path: 'threshold.value'
      },
      thresholdCardinalityField: {
        path: 'threshold.cardinality.field'
      },
      thresholdCardinalityValue: {
        path: 'threshold.cardinality.value'
      }
    }
  }, ThresholdInputChildren))), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: (0, _utils2.isThreatMatchRule)(ruleType),
    "data-test-subj": "threatMatchInput",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      threatMapping: {
        path: 'threatMapping'
      }
    }
  }, ThreatMatchInputChildren))), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: (0, _utils2.isNewTermsRule)(ruleType),
    "data-test-subj": "newTermsInput",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "newTermsFields",
    component: _new_terms_fields.NewTermsFields,
    componentProps: {
      browserFields: termsAggregationFields
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "historyWindowSize",
    component: _schedule_item_form.ScheduleItem,
    componentProps: {
      idAria: 'detectionEngineStepDefineRuleHistoryWindowSize',
      dataTestSubj: 'detectionEngineStepDefineRuleHistoryWindowSize',
      timeTypes: ['m', 'h', 'd']
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: isAlertSuppressionEnabled && isThresholdRule,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: alertSuppressionUpsellingMessage,
    position: "right"
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "enableThresholdSuppression",
    componentProps: {
      idAria: 'detectionEngineStepDefineRuleThresholdEnableSuppression',
      'data-test-subj': 'detectionEngineStepDefineRuleThresholdEnableSuppression',
      euiFieldProps: {
        label: i18n.getEnableThresholdSuppressionLabel(thresholdFields),
        disabled: !isAlertSuppressionLicenseValid
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: isAlertSuppressionEnabled && (0, _utils2.isQueryRule)(ruleType),
    "data-test-subj": "alertSuppressionInput"
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "groupByFields",
    component: _multi_select_fields.MultiSelectFieldsAutocomplete,
    componentProps: {
      browserFields: termsAggregationFields,
      disabledText: alertSuppressionUpsellingMessage,
      isDisabled: !isAlertSuppressionLicenseValid
    }
  })), /*#__PURE__*/_react.default.createElement(IntendedRuleTypeEuiFormRow, {
    $isVisible: isAlertSuppressionEnabled,
    "data-test-subj": "alertSuppressionDuration"
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      groupByRadioSelection: {
        path: 'groupByRadioSelection'
      },
      groupByDurationValue: {
        path: 'groupByDuration.value'
      },
      groupByDurationUnit: {
        path: 'groupByDuration.unit'
      }
    }
  }, GroupByChildren)), /*#__PURE__*/_react.default.createElement(IntendedRuleTypeEuiFormRow
  // only query rule has this suppression configuration
  , {
    $isVisible: isAlertSuppressionEnabled && (0, _utils2.isQueryRule)(ruleType),
    "data-test-subj": "alertSuppressionMissingFields",
    label: /*#__PURE__*/_react.default.createElement("span", null, i18n.ALERT_SUPPRESSION_MISSING_FIELDS_FORM_ROW_LABEL, " ", /*#__PURE__*/_react.default.createElement(_suppression_info_icon.SuppressionInfoIcon, null)),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      suppressionMissingFields: {
        path: 'suppressionMissingFields'
      }
    }
  }, AlertSuppressionMissingFields)), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "timeline",
    component: _pick_timeline.PickTimeline,
    componentProps: {
      idAria: 'detectionEngineStepDefineRuleTimeline',
      isDisabled: isLoading,
      dataTestSubj: 'detectionEngineStepDefineRuleTimeline'
    }
  }))));
};
const StepDefineRule = /*#__PURE__*/(0, _react.memo)(StepDefineRuleComponent);
exports.StepDefineRule = StepDefineRule;
const StepDefineRuleReadOnlyComponent = ({
  addPadding,
  defaultValues: data,
  descriptionColumns,
  indexPattern
}) => {
  const dataForDescription = (0, _helpers2.getStepDataDataSource)(data);
  return /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    "data-test-subj": "definitionRule",
    addPadding: addPadding
  }, /*#__PURE__*/_react.default.createElement(_description_step.StepRuleDescription, {
    columns: descriptionColumns,
    schema: (0, _helpers2.filterRuleFieldsForType)(_schema.schema, data.ruleType),
    data: (0, _helpers2.filterRuleFieldsForType)(dataForDescription, data.ruleType),
    indexPatterns: indexPattern
  }));
};
const StepDefineRuleReadOnly = /*#__PURE__*/(0, _react.memo)(StepDefineRuleReadOnlyComponent);
exports.StepDefineRuleReadOnly = StepDefineRuleReadOnly;
function aggregatableFields(browserFields) {
  return browserFields.filter(field => field.aggregatable === true);
}