"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewLogs = exports.CalloutGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomWarning = ({
  message
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: 'warning',
  iconType: "warning",
  "data-test-subj": 'preview-abort'
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, message)));
const addLogs = (startedAt, logs, duration, allLogs) => logs.length ? [{
  startedAt,
  logs,
  duration
}, ...allLogs] : allLogs;
const PreviewLogsComponent = ({
  logs,
  hasNoiseWarning,
  isAborted
}) => {
  const sortedLogs = (0, _react.useMemo)(() => logs.reduce(({
    errors,
    warnings
  }, curr) => ({
    errors: addLogs(curr.startedAt, curr.errors, curr.duration, errors),
    warnings: addLogs(curr.startedAt, curr.warnings, curr.duration, warnings)
  }), {
    errors: [],
    warnings: []
  }), [logs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), hasNoiseWarning !== null && hasNoiseWarning !== void 0 ? hasNoiseWarning : /*#__PURE__*/_react.default.createElement(CustomWarning, {
    message: i18n.QUERY_PREVIEW_NOISE_WARNING
  }), /*#__PURE__*/_react.default.createElement(LogAccordion, {
    logs: sortedLogs.errors,
    isError: true
  }), /*#__PURE__*/_react.default.createElement(LogAccordion, {
    logs: sortedLogs.warnings
  }, isAborted ? /*#__PURE__*/_react.default.createElement(CustomWarning, {
    message: i18n.PREVIEW_TIMEOUT_WARNING
  }) : null));
};
const PreviewLogs = /*#__PURE__*/_react.default.memo(PreviewLogsComponent);
exports.PreviewLogs = PreviewLogs;
PreviewLogs.displayName = 'PreviewLogs';
const LogAccordion = ({
  logs,
  isError,
  children
}) => {
  const firstLog = logs[0];
  if (!(children || firstLog)) return null;
  const restOfLogs = children ? logs : logs.slice(1);
  const bannerElement = children !== null && children !== void 0 ? children : /*#__PURE__*/_react.default.createElement(CalloutGroup, {
    logs: firstLog.logs,
    startedAt: firstLog.startedAt,
    isError: isError,
    duration: firstLog.duration
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, bannerElement, restOfLogs.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: isError ? 'previewErrorAccordion' : 'previewWarningAccordion',
    buttonContent: isError ? i18n.QUERY_PREVIEW_SEE_ALL_ERRORS : i18n.QUERY_PREVIEW_SEE_ALL_WARNINGS
  }, restOfLogs.map((log, key) => /*#__PURE__*/_react.default.createElement(CalloutGroup, {
    key: `accordion-log-${key}`,
    logs: log.logs,
    startedAt: log.startedAt,
    duration: log.duration,
    isError: isError
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const CalloutGroup = ({
  logs,
  startedAt,
  isError,
  duration
}) => {
  return logs.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, logs.map((log, i) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: i
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: isError ? 'danger' : 'warning',
    iconType: "warning",
    "data-test-subj": isError ? 'preview-error' : 'preview-warning',
    title: `${startedAt ? `[${startedAt}] ` : ''}[${duration}ms]`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, log))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))) : null;
};
exports.CalloutGroup = CalloutGroup;