"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActionsOverflow = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("../../../../../common/constants");
var _constants2 = require("../../../../../common/detection_engine/rule_management/constants");
var _rule_management = require("../../../../../common/api/detection_engine/rule_management");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _use_bool_state = require("../../../../common/hooks/use_bool_state");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _kibana = require("../../../../common/lib/kibana");
var _privileges = require("../../../../common/utils/privileges");
var _use_bulk_export = require("../../../../detection_engine/rule_management/logic/bulk_actions/use_bulk_export");
var _use_execute_bulk_action = require("../../../../detection_engine/rule_management/logic/bulk_actions/use_execute_bulk_action");
var _use_download_exported_rules = require("../../../../detection_engine/rule_management/logic/bulk_actions/use_download_exported_rules");
var i18nActions = _interopRequireWildcard(require("../../../pages/detection_engine/rules/translations"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyEuiButtonIcon = (0, _styledComponents.default)(_eui.EuiButtonIcon)`
  &.euiButtonIcon {
    svg {
      transform: rotate(90deg);
    }
    border: 1px solid ${({
  theme
}) => theme.euiColorPrimary};
    width: 40px;
    height: 40px;
  }
`;
/**
 * Overflow Actions for a Rule
 */
const RuleActionsOverflowComponent = ({
  rule,
  userHasPermissions,
  canDuplicateRuleWithActions,
  showBulkDuplicateExceptionsConfirmation,
  confirmDeletion
}) => {
  const [isPopoverOpen,, closePopover, togglePopover] = (0, _use_bool_state.useBoolState)();
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const {
    executeBulkAction
  } = (0, _use_execute_bulk_action.useExecuteBulkAction)({
    suppressSuccessToast: true
  });
  const {
    bulkExport
  } = (0, _use_bulk_export.useBulkExport)();
  const downloadExportedRules = (0, _use_download_exported_rules.useDownloadExportedRules)();
  const onRuleDeletedCallback = (0, _react.useCallback)(() => {
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _constants.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRulesUrl)()
    });
  }, [navigateToApp]);
  const actions = (0, _react.useMemo)(() => rule != null ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: i18nActions.DUPLICATE_RULE,
    icon: "copy",
    disabled: !canDuplicateRuleWithActions || !userHasPermissions,
    "data-test-subj": "rules-details-duplicate-rule",
    onClick: async () => {
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.DUPLICATE
      });
      closePopover();
      const modalDuplicationConfirmationResult = await showBulkDuplicateExceptionsConfirmation();
      if (modalDuplicationConfirmationResult === null) {
        return;
      }
      const result = await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.duplicate,
        ids: [rule.id],
        duplicatePayload: {
          include_exceptions: modalDuplicationConfirmationResult === _constants2.DuplicateOptions.withExceptions || modalDuplicationConfirmationResult === _constants2.DuplicateOptions.withExceptionsExcludeExpiredExceptions,
          include_expired_exceptions: !(modalDuplicationConfirmationResult === _constants2.DuplicateOptions.withExceptionsExcludeExpiredExceptions)
        }
      });
      const createdRules = result === null || result === void 0 ? void 0 : result.attributes.results.created;
      if (createdRules !== null && createdRules !== void 0 && createdRules.length) {
        (0, _use_execute_bulk_action.goToRuleEditPage)(createdRules[0].id, navigateToApp);
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: !(0, _privileges.canEditRuleWithActions)(rule, canDuplicateRuleWithActions) ? i18nActions.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18nActions.DUPLICATE_RULE))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: i18nActions.EXPORT_RULE,
    icon: "exportAction",
    disabled: !userHasPermissions || rule.immutable,
    "data-test-subj": "rules-details-export-rule",
    onClick: async () => {
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.EXPORT
      });
      closePopover();
      const response = await bulkExport({
        ids: [rule.id]
      });
      if (response) {
        await downloadExportedRules(response);
      }
    }
  }, i18nActions.EXPORT_RULE), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: i18nActions.DELETE_RULE,
    icon: "trash",
    disabled: !userHasPermissions,
    "data-test-subj": "rules-details-delete-rule",
    onClick: async () => {
      closePopover();
      if ((await confirmDeletion()) === false) {
        // User has canceled deletion
        return;
      }
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.DELETE
      });
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.delete,
        ids: [rule.id]
      });
      onRuleDeletedCallback();
    }
  }, i18nActions.DELETE_RULE)] : [], [bulkExport, canDuplicateRuleWithActions, closePopover, executeBulkAction, navigateToApp, onRuleDeletedCallback, rule, showBulkDuplicateExceptionsConfirmation, startTransaction, userHasPermissions, downloadExportedRules, confirmDeletion]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18n.ALL_ACTIONS
  }, /*#__PURE__*/_react.default.createElement(MyEuiButtonIcon, {
    iconType: "boxesHorizontal",
    "aria-label": i18n.ALL_ACTIONS,
    isDisabled: !userHasPermissions,
    "data-test-subj": "rules-details-popover-button-icon",
    onClick: togglePopover
  })), [togglePopover, userHasPermissions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "leftCenter",
    button: button,
    closePopover: closePopover,
    id: "ruleActionsOverflow",
    isOpen: isPopoverOpen,
    "data-test-subj": "rules-details-popover",
    ownFocus: true,
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "rules-details-menu-panel",
    items: actions
  })));
};
const RuleActionsOverflow = /*#__PURE__*/_react.default.memo(RuleActionsOverflowComponent);
exports.RuleActionsOverflow = RuleActionsOverflow;
RuleActionsOverflow.displayName = 'RuleActionsOverflow';