"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _securitysolutionAutocomplete = require("@kbn/securitysolution-autocomplete");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NestedContent = _styledComponents.default.div`
  margin-left: 24px;
`;
const EuiFlexItemComboBoxColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 376px;
`;
const EuiFlexItemIconColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 20px;
`;
const EuiFlexItemRiskScoreColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 160px;
`;
const RiskScoreField = ({
  dataTestSubj,
  field,
  idAria,
  indices,
  isDisabled,
  isActive,
  placeholder
}) => {
  const {
    value,
    isMappingChecked,
    mapping
  } = field.value;
  const {
    setValue
  } = field;
  const fieldTypeFilter = (0, _react.useMemo)(() => ['number'], []);
  const selectedField = (0, _react.useMemo)(() => getFieldTypeByMapping(mapping, indices), [mapping, indices]);
  const handleDefaultRiskScoreChange = (0, _react.useCallback)(e => {
    const range = e.target.value;
    setValue({
      value: Number(range.trim()),
      isMappingChecked,
      mapping
    });
  }, [setValue, isMappingChecked, mapping]);
  const handleRiskScoreMappingChange = (0, _react.useCallback)(([newField]) => {
    var _newField$name;
    setValue({
      value,
      isMappingChecked,
      mapping: [{
        field: (_newField$name = newField === null || newField === void 0 ? void 0 : newField.name) !== null && _newField$name !== void 0 ? _newField$name : '',
        operator: 'equals',
        value: '',
        risk_score: undefined
      }]
    });
  }, [setValue, value, isMappingChecked]);
  const handleRiskScoreMappingChecked = (0, _react.useCallback)(() => {
    setValue({
      value,
      isMappingChecked: !isMappingChecked,
      mapping: [...mapping]
    });
  }, [setValue, value, isMappingChecked, mapping]);
  const riskScoreLabel = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, i18n.DEFAULT_RISK_SCORE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs'
    }, i18n.RISK_SCORE_DESCRIPTION));
  }, []);
  const riskScoreMappingLabel = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      onClick: !isDisabled ? handleRiskScoreMappingChecked : _fp.noop
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: `risk_score-mapping-override`,
      checked: isMappingChecked,
      disabled: isDisabled,
      onChange: handleRiskScoreMappingChecked
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, i18n.RISK_SCORE_MAPPING)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(NestedContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs'
    }, i18n.RISK_SCORE_MAPPING_DESCRIPTION)));
  }, [isMappingChecked, handleRiskScoreMappingChecked, isDisabled]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isActive && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: riskScoreLabel,
    labelAppend: field.labelAppend,
    helpText: field.helpText,
    error: 'errorMessage',
    isInvalid: false,
    fullWidth: true,
    "data-test-subj": `${dataTestSubj}-defaultRisk`,
    describedByIds: idAria ? [idAria] : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    value: value,
    onChange: handleDefaultRiskScoreChange,
    max: 100,
    min: 0,
    showRange: true,
    showInput: true,
    fullWidth: false,
    showTicks: true,
    tickInterval: 25,
    "data-test-subj": `${dataTestSubj}-defaultRiskRange`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: riskScoreMappingLabel,
    labelAppend: field.labelAppend,
    helpText: isMappingChecked ? /*#__PURE__*/_react.default.createElement(NestedContent, null, i18n.RISK_SCORE_MAPPING_DETAILS) : '',
    error: 'errorMessage',
    isInvalid: false,
    fullWidth: true,
    "data-test-subj": `${dataTestSubj}-riskOverride`,
    describedByIds: idAria ? [idAria] : undefined
  }, /*#__PURE__*/_react.default.createElement(NestedContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), isMappingChecked && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column',
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(EuiFlexItemComboBoxColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, i18n.SOURCE_FIELD)), /*#__PURE__*/_react.default.createElement(EuiFlexItemIconColumn, {
    grow: false
  }), /*#__PURE__*/_react.default.createElement(EuiFlexItemRiskScoreColumn, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, i18n.DEFAULT_RISK_SCORE)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(EuiFlexItemComboBoxColumn, null, /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.FieldComponent, {
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : '',
    indexPattern: indices,
    selectedField: selectedField,
    fieldTypeFilter: fieldTypeFilter,
    isLoading: false,
    isClearable: false,
    isDisabled: isDisabled,
    onChange: handleRiskScoreMappingChange,
    "data-test-subj": dataTestSubj,
    "aria-label": idAria
  })), /*#__PURE__*/_react.default.createElement(EuiFlexItemIconColumn, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: 'sortRight'
  })), /*#__PURE__*/_react.default.createElement(EuiFlexItemRiskScoreColumn, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's'
  }, i18n.RISK_SCORE_FIELD)))))))));
};

/**
 * Looks for field metadata (DataViewFieldBase) in existing index pattern.
 * If specified field doesn't exist, returns a stub DataViewFieldBase created based on the mapping --
 * because the field might not have been indexed yet, but we still need to display the mapping.
 *
 * @param mapping Mapping of a specified field name to risk score.
 * @param pattern Existing index pattern.
 */
exports.RiskScoreField = RiskScoreField;
const getFieldTypeByMapping = (mapping, pattern) => {
  var _mapping$0$field, _mapping$;
  const field = (_mapping$0$field = mapping === null || mapping === void 0 ? void 0 : (_mapping$ = mapping[0]) === null || _mapping$ === void 0 ? void 0 : _mapping$.field) !== null && _mapping$0$field !== void 0 ? _mapping$0$field : '';
  const [knownFieldType] = pattern.fields.filter(({
    name
  }) => field != null && field === name);
  return knownFieldType !== null && knownFieldType !== void 0 ? knownFieldType : {
    name: field,
    type: 'number'
  };
};