"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationStatusBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PaddedBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  margin-left: 5px;
`;
const IntegrationStatusBadgeComponent = ({
  integration
}) => {
  const {
    installationStatus
  } = integration;
  if (!installationStatus.isKnown) {
    return null;
  }
  const {
    isInstalled,
    isEnabled
  } = installationStatus;
  const badgeInstalledColor = 'success';
  const badgeUninstalledColor = '#E0E5EE';
  const badgeColor = isInstalled ? badgeInstalledColor : badgeUninstalledColor;
  const badgeTooltip = isInstalled ? isEnabled ? i18n.INTEGRATIONS_ENABLED_TOOLTIP : i18n.INTEGRATIONS_INSTALLED_TOOLTIP : i18n.INTEGRATIONS_UNINSTALLED_TOOLTIP;
  const badgeText = isInstalled ? isEnabled ? i18n.INTEGRATIONS_ENABLED : i18n.INTEGRATIONS_INSTALLED : i18n.INTEGRATIONS_UNINSTALLED;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: badgeTooltip
  }, /*#__PURE__*/_react.default.createElement(PaddedBadge, {
    color: badgeColor,
    "data-test-subj": 'statusBadge'
  }, badgeText));
};
const IntegrationStatusBadge = /*#__PURE__*/_react.default.memo(IntegrationStatusBadgeComponent);
exports.IntegrationStatusBadge = IntegrationStatusBadge;
IntegrationStatusBadge.displayName = 'IntegrationStatusBadge';