"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryBarDefineRule = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _public = require("@kbn/data-plugin/public");
var _open_timeline_modal = require("../../../../timelines/components/open_timeline/open_timeline_modal");
var _query_bar = require("../../../../common/components/query_bar");
var _kibana = require("../../../../common/lib/kibana");
var _saved_query_services = require("../../../../common/utils/saved_query_services");
var _shared_imports = require("../../../../shared_imports");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionTimelineToHide = ['duplicate', 'createFrom'];
const getFieldValueFromEmptySavedQuery = () => ({
  filters: [],
  query: {
    query: '',
    language: 'kuery'
  },
  saved_id: null
});
const savedQueryToFieldValue = savedQuery => {
  var _savedQuery$attribute;
  return {
    filters: (_savedQuery$attribute = savedQuery.attributes.filters) !== null && _savedQuery$attribute !== void 0 ? _savedQuery$attribute : [],
    query: savedQuery.attributes.query,
    saved_id: savedQuery.id,
    title: savedQuery.attributes.title
  };
};
const QueryBarDefineRule = ({
  defaultSavedQuery,
  browserFields,
  dataTestSubj,
  field,
  idAria,
  indexPattern,
  isLoading = false,
  onCloseTimelineSearch,
  openTimelineSearch = false,
  resizeParentContainer,
  onValidityChange,
  isDisabled,
  resetToSavedQuery,
  onOpenTimeline,
  onSavedQueryError
}) => {
  const {
    value: fieldValue,
    setValue: setFieldValue
  } = field;
  const [originalHeight, setOriginalHeight] = (0, _react.useState)(-1);
  const [loadingTimeline, setLoadingTimeline] = (0, _react.useState)(false);
  const [savedQuery, setSavedQuery] = (0, _react.useState)(defaultSavedQuery);
  const [isSavedQueryFailedToLoad, setIsSavedQueryFailedToLoad] = (0, _react.useState)(false);
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const [filterManager] = (0, _react.useState)(new _public.FilterManager(uiSettings));
  const savedQueryServices = (0, _saved_query_services.useSavedQueryServices)();

  // Bubbles up field validity to parent.
  // Using something like form `getErrors` does
  // not guarantee latest validity state
  (0, _react.useEffect)(() => {
    if (onValidityChange != null) {
      onValidityChange(!isInvalid);
    }
  }, [isInvalid, onValidityChange]);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const subscriptions = new _rxjs.Subscription();
    filterManager.setFilters([]);
    subscriptions.add(filterManager.getUpdates$().subscribe({
      next: () => {
        if (isSubscribed) {
          const newFilters = filterManager.getFilters();
          const {
            filters
          } = fieldValue;
          if (!(0, _fastDeepEqual.default)(filters, newFilters)) {
            setFieldValue({
              ...fieldValue,
              filters: newFilters
            });
          }
        }
      }
    }));
    return () => {
      isSubscribed = false;
      subscriptions.unsubscribe();
    };
  }, [fieldValue, filterManager, setFieldValue]);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    async function updateFilterQueryFromValue() {
      const {
        filters,
        saved_id: savedId
      } = fieldValue;
      if (!(0, _fastDeepEqual.default)(filters, filterManager.getFilters())) {
        filterManager.setFilters(filters);
      }
      if (savedId != null && savedQuery != null && savedId !== savedQuery.id || savedId != null && savedQuery == null) {
        try {
          const mySavedQuery = await savedQueryServices.getSavedQuery(savedId);
          if (isSubscribed && mySavedQuery != null) {
            setSavedQuery(mySavedQuery);
          }
          setIsSavedQueryFailedToLoad(false);
        } catch {
          setSavedQuery(undefined);
          setIsSavedQueryFailedToLoad(true);
        }
      } else if (savedId == null && savedQuery != null) {
        setSavedQuery(undefined);
      }
    }
    updateFilterQueryFromValue();
    return () => {
      isSubscribed = false;
    };
  }, [fieldValue, filterManager, savedQuery, savedQueryServices, setIsSavedQueryFailedToLoad, setFieldValue]);
  (0, _react.useEffect)(() => {
    if (isSavedQueryFailedToLoad) {
      onSavedQueryError === null || onSavedQueryError === void 0 ? void 0 : onSavedQueryError();
    }
  }, [onSavedQueryError, isSavedQueryFailedToLoad]);

  // if saved query fetched, reset values in queryBar input and filters to saved query's values
  (0, _react.useEffect)(() => {
    if (resetToSavedQuery && savedQuery) {
      const newFiledValue = savedQueryToFieldValue(savedQuery);
      setFieldValue(newFiledValue);
    }
  }, [resetToSavedQuery, savedQuery, setFieldValue]);
  const onSubmitQuery = (0, _react.useCallback)(newQuery => {
    const {
      query
    } = fieldValue;
    if (!(0, _fastDeepEqual.default)(query, newQuery)) {
      setFieldValue({
        ...fieldValue,
        query: newQuery
      });
    }
  }, [fieldValue, setFieldValue]);
  const onChangedQuery = (0, _react.useCallback)(newQuery => {
    const {
      query
    } = fieldValue;
    if (!(0, _fastDeepEqual.default)(query, newQuery)) {
      // if saved query failed to load, delete saved_id, when user types custom query
      const savedId = isSavedQueryFailedToLoad ? null : fieldValue.saved_id;
      setFieldValue({
        ...fieldValue,
        query: newQuery,
        saved_id: savedId
      });
    }
  }, [fieldValue, setFieldValue, isSavedQueryFailedToLoad]);
  const onSavedQuery = (0, _react.useCallback)(newSavedQuery => {
    if (newSavedQuery != null) {
      const {
        saved_id: savedId
      } = fieldValue;
      setIsSavedQueryFailedToLoad(false);
      setSavedQuery(newSavedQuery);
      if (newSavedQuery.id !== savedId) {
        const newFiledValue = savedQueryToFieldValue(newSavedQuery);
        setFieldValue(newFiledValue);
      } else {
        setFieldValue(getFieldValueFromEmptySavedQuery());
      }
    }
  }, [fieldValue, setFieldValue, setIsSavedQueryFailedToLoad]);
  const onCloseTimelineModal = (0, _react.useCallback)(() => {
    setLoadingTimeline(true);
    onCloseTimelineSearch();
  }, [onCloseTimelineSearch]);
  const onOpenTimelineCb = (0, _react.useCallback)(timeline => {
    setLoadingTimeline(false);
    onOpenTimeline === null || onOpenTimeline === void 0 ? void 0 : onOpenTimeline(timeline);
  }, [onOpenTimeline]);
  const onMutation = () => {
    if (resizeParentContainer != null) {
      const suggestionContainer = document.getElementById('kbnTypeahead__items');
      if (suggestionContainer != null) {
        const box = suggestionContainer.getBoundingClientRect();
        const accordionContainer = document.getElementById('define-rule');
        if (accordionContainer != null) {
          const accordionBox = accordionContainer.getBoundingClientRect();
          if (originalHeight === -1 || accordionBox.height < originalHeight + box.height) {
            resizeParentContainer(originalHeight + box.height - 100);
          }
          if (originalHeight === -1) {
            setOriginalHeight(accordionBox.height);
          }
        }
      } else {
        resizeParentContainer(-1);
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: field.label,
    labelAppend: field.labelAppend,
    helpText: field.helpText,
    error: errorMessage,
    isInvalid: isInvalid,
    fullWidth: true,
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiMutationObserver, {
    observerOptions: {
      subtree: true,
      attributes: true,
      childList: true
    },
    onMutation: onMutation
  }, mutationRef => /*#__PURE__*/_react.default.createElement("div", {
    ref: mutationRef
  }, /*#__PURE__*/_react.default.createElement(_query_bar.QueryBar, {
    indexPattern: indexPattern,
    isLoading: isLoading || loadingTimeline,
    isRefreshPaused: false,
    filterQuery: fieldValue.query,
    filterManager: filterManager,
    filters: filterManager.getFilters() || [],
    onChangedQuery: onChangedQuery,
    onSubmitQuery: onSubmitQuery,
    savedQuery: savedQuery,
    onSavedQuery: onSavedQuery,
    hideSavedQuery: false,
    displayStyle: "inPage",
    isDisabled: isDisabled
  })))), openTimelineSearch ? /*#__PURE__*/_react.default.createElement(_open_timeline_modal.OpenTimelineModal, {
    hideActions: actionTimelineToHide,
    modalTitle: i18n.IMPORT_TIMELINE_MODAL,
    onClose: onCloseTimelineModal,
    onOpen: onOpenTimelineCb
  }) : null);
};
exports.QueryBarDefineRule = QueryBarDefineRule;