"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlJobItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../../../../../common/machine_learning/helpers");
var _ml_job_link = require("../ml_job_link/ml_job_link");
var _ml_audit_icon = require("../ml_audit_icon");
var _ml_job_status_badge = require("../ml_job_status_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Wrapper = _styledComponents.default.div`
  overflow: hidden;
`;
const MlJobItemComponent = ({
  job,
  switchComponent,
  ...props
}) => {
  var _job$customSettings;
  const isStarted = (0, _helpers.isJobStarted)(job.jobState, job.datafeedState);
  return /*#__PURE__*/_react.default.createElement(Wrapper, props, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_ml_job_link.MlJobLink, {
    jobId: job.id,
    jobName: (_job$customSettings = job.customSettings) === null || _job$customSettings === void 0 ? void 0 : _job$customSettings.security_app_display_name
  }), /*#__PURE__*/_react.default.createElement(_ml_audit_icon.MlAuditIcon, {
    message: job.auditMessage
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      marginRight: '0'
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_job_status_badge.MlJobStatusBadge, {
    job: job
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, switchComponent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      marginLeft: '0'
    },
    "data-test-subj": "mlJobActionLabel"
  }, isStarted ? i18n.ML_STOP_JOB_LABEL : i18n.ML_RUN_JOB_LABEL)));
};
const MlJobItem = /*#__PURE__*/(0, _react.memo)(MlJobItemComponent);
exports.MlJobItem = MlJobItem;