"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlJobLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/ml-plugin/public");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledJobEuiLInk = (0, _styledComponents.default)(_eui.EuiLink)`
  margin-right: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const MlJobLinkComponent = ({
  jobId,
  jobName
}) => {
  const {
    services: {
      http,
      ml
    }
  } = (0, _kibana.useKibana)();
  const jobUrl = (0, _public.useMlHref)(ml, http.basePath.get(), {
    page: _public.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE,
    pageState: {
      jobId: [jobId]
    }
  }, [jobId]);
  return /*#__PURE__*/_react.default.createElement(StyledJobEuiLInk, {
    "data-test-subj": "machineLearningJobLink",
    href: jobUrl,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "machineLearningJob"
  }, jobName !== null && jobName !== void 0 ? jobName : jobId));
};
const MlJobLink = /*#__PURE__*/(0, _react.memo)(MlJobLinkComponent);
exports.MlJobLink = MlJobLink;