"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DurationInput = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _shared_imports = require("../../../../shared_imports");
var I18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNumberFromUserInput = (input, minimumValue = 0) => {
  const number = parseInt(input, 10);
  if (Number.isNaN(number)) {
    return minimumValue;
  } else {
    return Math.max(minimumValue, Math.min(number, Number.MAX_SAFE_INTEGER));
  }
};
const StyledEuiFormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  max-width: none;

  .euiFormControlLayout {
    max-width: 235px;
    width: auto;
  }

  .euiFormControlLayout__childrenWrapper > *:first-child {
    box-shadow: none;
    height: 38px;
    width: 100%;
  }

  .euiFormControlLayout__childrenWrapper > select {
    background-color: ${({
  theme
}) => (0, _eui.transparentize)(theme.eui.euiColorPrimary, 0.1)};
    color: ${({
  theme
}) => theme.eui.euiColorPrimary};
  }

  .euiFormControlLayout--group .euiFormControlLayout {
    min-width: 100px;
  }

  .euiFormControlLayoutIcons {
    color: ${({
  theme
}) => theme.eui.euiColorPrimary};
  }

  .euiFormControlLayout:not(:first-child) {
    border-left: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
  }
`;
const MyEuiSelect = (0, _styledComponents.default)(_eui.EuiSelect)`
  width: auto;
`;

// This component is similar to the ScheduleItem component, but instead of combining the value
// and unit into a single string it keeps them separate. This makes the component simpler and
// allows for easier validation of values and units in APIs as well.
const DurationInputComponent = ({
  durationValueField,
  durationUnitField,
  minimumValue = 0,
  isDisabled,
  durationUnitOptions = [{
    value: 's',
    text: I18n.SECONDS
  }, {
    value: 'm',
    text: I18n.MINUTES
  }, {
    value: 'h',
    text: I18n.HOURS
  }],
  ...props
}) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(durationValueField);
  const {
    value: durationValue,
    setValue: setDurationValue
  } = durationValueField;
  const {
    value: durationUnit,
    setValue: setDurationUnit
  } = durationUnitField;
  const onChangeTimeType = (0, _react.useCallback)(e => {
    setDurationUnit(e.target.value);
  }, [setDurationUnit]);
  const onChangeTimeVal = (0, _react.useCallback)(e => {
    const sanitizedValue = getNumberFromUserInput(e.target.value, minimumValue);
    setDurationValue(sanitizedValue);
  }, [minimumValue, setDurationValue]);

  // EUI missing some props
  const rest = {
    disabled: isDisabled,
    ...props
  };
  return /*#__PURE__*/_react.default.createElement(StyledEuiFormRow, {
    error: errorMessage,
    isInvalid: isInvalid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    append: /*#__PURE__*/_react.default.createElement(MyEuiSelect, (0, _extends2.default)({
      fullWidth: false,
      options: durationUnitOptions,
      onChange: onChangeTimeType,
      value: durationUnit,
      "data-test-subj": "timeType"
    }, rest))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({
    fullWidth: false,
    min: minimumValue,
    max: Number.MAX_SAFE_INTEGER,
    onChange: onChangeTimeVal,
    value: durationValue,
    "data-test-subj": "interval"
  }, rest))));
};
const DurationInput = /*#__PURE__*/_react.default.memo(DurationInputComponent);
exports.DurationInput = DurationInput;