"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SentinelOneAgentStatus = exports.SENTINEL_ONE_NETWORK_STATUS = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _types = require("../../../../common/endpoint/types");
var _agent_status_text = require("../../../common/components/endpoint/agent_status_text");
var _host_constants = require("../../../management/pages/endpoint_hosts/view/host_constants");
var _use_sentinelone_host_isolation = require("./use_sentinelone_host_isolation");
var _endpoint_agent_status = require("../../../common/components/endpoint/endpoint_agent_status");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSentinelOneAgentStatus = data => {
  if (!data) {
    return _types.HostStatus.UNENROLLED;
  }
  if (!(data !== null && data !== void 0 && data.isActive)) {
    return _types.HostStatus.OFFLINE;
  }
  return _types.HostStatus.HEALTHY;
};
let SENTINEL_ONE_NETWORK_STATUS;
exports.SENTINEL_ONE_NETWORK_STATUS = SENTINEL_ONE_NETWORK_STATUS;
(function (SENTINEL_ONE_NETWORK_STATUS) {
  SENTINEL_ONE_NETWORK_STATUS["CONNECTING"] = "connecting";
  SENTINEL_ONE_NETWORK_STATUS["CONNECTED"] = "connected";
  SENTINEL_ONE_NETWORK_STATUS["DISCONNECTING"] = "disconnecting";
  SENTINEL_ONE_NETWORK_STATUS["DISCONNECTED"] = "disconnected";
})(SENTINEL_ONE_NETWORK_STATUS || (exports.SENTINEL_ONE_NETWORK_STATUS = SENTINEL_ONE_NETWORK_STATUS = {}));
const EuiFlexGroupStyled = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  .isolation-status {
    margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
  }
`;
const SentinelOneAgentStatus = /*#__PURE__*/_react.default.memo(({
  agentId,
  'data-test-subj': dataTestSubj
}) => {
  var _data$data2;
  const {
    data,
    isFetched
  } = (0, _use_sentinelone_host_isolation.useSentinelOneAgentData)({
    agentId
  });
  const label = (0, _react.useMemo)(() => {
    var _data$data, _data$data$data, _data$data$data$;
    const networkStatus = data === null || data === void 0 ? void 0 : (_data$data = data.data) === null || _data$data === void 0 ? void 0 : (_data$data$data = _data$data.data) === null || _data$data$data === void 0 ? void 0 : (_data$data$data$ = _data$data$data[0]) === null || _data$data$data$ === void 0 ? void 0 : _data$data$data$.networkStatus;
    if (networkStatus === SENTINEL_ONE_NETWORK_STATUS.DISCONNECTING) {
      return _endpoint_agent_status.ISOLATING_LABEL;
    }
    if (networkStatus === SENTINEL_ONE_NETWORK_STATUS.DISCONNECTED) {
      return _endpoint_agent_status.ISOLATED_LABEL;
    }
    if (networkStatus === SENTINEL_ONE_NETWORK_STATUS.CONNECTING) {
      return _endpoint_agent_status.RELEASING_LABEL;
    }
  }, [data === null || data === void 0 ? void 0 : (_data$data2 = data.data) === null || _data$data2 === void 0 ? void 0 : _data$data2.data]);
  const agentStatus = (0, _react.useMemo)(() => {
    var _data$data3, _data$data3$data;
    return getSentinelOneAgentStatus(data === null || data === void 0 ? void 0 : (_data$data3 = data.data) === null || _data$data3 === void 0 ? void 0 : (_data$data3$data = _data$data3.data) === null || _data$data3$data === void 0 ? void 0 : _data$data3$data[0]);
  }, [data]);
  return /*#__PURE__*/_react.default.createElement(EuiFlexGroupStyled, {
    gutterSize: "none",
    responsive: false,
    className: "eui-textTruncate",
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isFetched ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: _host_constants.HOST_STATUS_TO_BADGE_COLOR[agentStatus],
    className: "eui-textTruncate"
  }, (0, _agent_status_text.getAgentStatusText)(agentStatus)) : '-'), label && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate isolation-status"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, label))));
});
exports.SentinelOneAgentStatus = SentinelOneAgentStatus;
SentinelOneAgentStatus.displayName = 'SentinelOneAgentStatus';