"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IsolateSentinelOneHost = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/stack-connectors-plugin/public/common");
var _use_load_connectors = require("../../../common/components/response_actions/use_load_connectors");
var _use_sub_action_mutation = require("../../../timelines/components/side_panel/event_details/flyout/use_sub_action_mutation");
var _translations = require("./translations");
var _host_isolation = require("../../../common/components/endpoint/host_isolation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IsolateSentinelOneHost = /*#__PURE__*/_react.default.memo(({
  sentinelOneAgentId,
  hostName,
  cancelCallback,
  successCallback
}) => {
  const {
    data: connectors
  } = (0, _use_load_connectors.useLoadConnectors)({
    actionTypeId: _common.SENTINELONE_CONNECTOR_ID
  });
  const connector = (0, _react.useMemo)(() => connectors === null || connectors === void 0 ? void 0 : connectors[0], [connectors]);
  const [isIsolated, setIsIsolated] = (0, _react.useState)(false);
  const {
    mutateAsync: isolateHost,
    isLoading
  } = (0, _use_sub_action_mutation.useSubActionMutation)({
    connectorId: connector === null || connector === void 0 ? void 0 : connector.id,
    subAction: _common.SUB_ACTION.ISOLATE_HOST,
    subActionParams: {
      uuid: sentinelOneAgentId
    }
  });
  const onChange = (0, _react.useCallback)(() => {}, []);
  const confirmHostIsolation = (0, _react.useCallback)(async () => {
    const response = await isolateHost();
    if (response.status === 'ok') {
      setIsIsolated(true);
      if (successCallback) {
        successCallback();
      }
    }
  }, [isolateHost, successCallback]);
  const backToAlertDetails = (0, _react.useCallback)(() => cancelCallback(), [cancelCallback]);
  const hostIsolatedSuccessButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_host_isolation.ActionCompletionReturnButton, {
    onClick: backToAlertDetails,
    buttonText: _translations.RETURN_TO_ALERT_DETAILS
  }), [backToAlertDetails]);
  const hostNotIsolated = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_host_isolation.EndpointIsolateForm, {
    hostName: hostName,
    onCancel: backToAlertDetails,
    onConfirm: confirmHostIsolation,
    isLoading: isLoading,
    onChange: onChange,
    hideCommentField: true
  })), [hostName, backToAlertDetails, confirmHostIsolation, isLoading, onChange]);
  return isIsolated ? hostIsolatedSuccessButton : hostNotIsolated;
});
exports.IsolateSentinelOneHost = IsolateSentinelOneHost;
IsolateSentinelOneHost.displayName = 'IsolateSentinelOneHost';