"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.needAdminForUpdateCallOutBody = exports.NEED_ADMIN_CALLOUT_TITLE = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _links_to_docs = require("../../../../common/components/links_to_docs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NEED_ADMIN_CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.needAdminForUpdateCallOutBody.messageTitle', {
  defaultMessage: 'Administration permissions required for alert migration'
});

/**
 * Returns the formatted message of the call out body as a JSX Element with both the message
 * and two documentation links.
 */
exports.NEED_ADMIN_CALLOUT_TITLE = NEED_ADMIN_CALLOUT_TITLE;
const needAdminForUpdateCallOutBody = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.needAdminForUpdateCallOutBody.messageBody.messageDetail",
  defaultMessage: "{essence} Related documentation: {docs}",
  values: {
    essence: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.needAdminForUpdateCallOutBody.messageBody.essenceDescription",
      defaultMessage: "You are currently missing the required permissions to auto migrate your alert data. Please have your administrator visit this page one time to auto migrate your alert data."
    })),
    docs: /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_links_to_docs.DetectionsRequirementsLink, null)), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_links_to_docs.SecuritySolutionRequirementsLink, null)))
  }
});
exports.needAdminForUpdateCallOutBody = needAdminForUpdateCallOutBody;