"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExceptionFlyout = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useExceptionFlyout = ({
  refetch,
  onRuleChange,
  isActiveTimelines
}) => {
  const [openAddExceptionFlyout, setOpenAddExceptionFlyout] = (0, _react.useState)(false);
  const [exceptionFlyoutType, setExceptionFlyoutType] = (0, _react.useState)(null);
  const onAddExceptionTypeClick = (0, _react.useCallback)(exceptionListType => {
    setExceptionFlyoutType(exceptionListType !== null && exceptionListType !== void 0 ? exceptionListType : null);
    setOpenAddExceptionFlyout(true);
  }, []);
  const onAddExceptionCancel = (0, _react.useCallback)(() => {
    setExceptionFlyoutType(null);
    setOpenAddExceptionFlyout(false);
  }, []);
  const onAddExceptionConfirm = (0, _react.useCallback)((didRuleChange, didCloseAlert, didBulkCloseAlert) => {
    if (refetch && (isActiveTimelines === false || didBulkCloseAlert)) {
      refetch();
    }
    if (onRuleChange != null && didRuleChange) {
      onRuleChange();
    }
    setOpenAddExceptionFlyout(false);
  }, [onRuleChange, refetch, isActiveTimelines]);
  return {
    exceptionFlyoutType,
    openAddExceptionFlyout,
    onAddExceptionTypeClick,
    onAddExceptionCancel,
    onAddExceptionConfirm
  };
};
exports.useExceptionFlyout = useExceptionFlyout;