"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackByComboBoxWrapper = exports.StackByComboBox = exports.KpiPanel = void 0;
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireWildcard(require("react"));
var _config = require("./config");
var _hooks = require("./hooks");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_WIDTH = 400;
const KpiPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  display: flex;
  flex-direction: column;
  position: relative;
  overflow-x: hidden;
  overflow-y: ${({
  $overflowY
}) => $overflowY !== null && $overflowY !== void 0 ? $overflowY : 'hidden'};
  @media only screen and (min-width: ${props => props.theme.eui.euiBreakpoints.m}) {
    ${({
  height,
  $toggleStatus
}) => $toggleStatus && `
      height: ${height != null ? height : _config.PANEL_HEIGHT}px;
  `}
  }
  ${({
  $toggleStatus
}) => $toggleStatus && `
    height: ${_config.MOBILE_PANEL_HEIGHT}px;
  `}
`;
exports.KpiPanel = KpiPanel;
const StackByComboBoxWrapper = _styledComponents.default.div`
  max-width: 400px;
  width: ${({
  width
}) => width}px;
`;
exports.StackByComboBoxWrapper = StackByComboBoxWrapper;
const StackByComboBox = /*#__PURE__*/_react.default.forwardRef(({
  'aria-label': ariaLabel = i18n.STACK_BY_ARIA_LABEL,
  'data-test-subj': dataTestSubj,
  isDisabled = false,
  onSelect,
  prepend = i18n.STACK_BY_LABEL,
  selected,
  inputRef,
  width = DEFAULT_WIDTH,
  dropDownoptions,
  useLensCompatibleFields
}, ref) => {
  const onChange = (0, _react.useCallback)(options => {
    if (options && options.length > 0) {
      onSelect(options[0].value);
    } else {
      onSelect('');
    }
  }, [onSelect]);
  const selectedOptions = (0, _react.useMemo)(() => {
    return [{
      label: selected,
      value: selected
    }];
  }, [selected]);
  const getExpensiveFields = (0, _hooks.useStackByFields)(useLensCompatibleFields);
  const options = (0, _react.useMemo)(() => dropDownoptions !== null && dropDownoptions !== void 0 ? dropDownoptions : getExpensiveFields(), [dropDownoptions, getExpensiveFields]);
  const singleSelection = (0, _react.useMemo)(() => {
    return {
      asPlainText: true
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(StackByComboBoxWrapper, {
    width: width
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": dataTestSubj,
    "aria-label": ariaLabel,
    inputRef: inputRef,
    isDisabled: isDisabled,
    placeholder: i18n.STACK_BY_PLACEHOLDER,
    prepend: prepend,
    ref: ref,
    singleSelection: singleSelection,
    isClearable: false,
    sortMatchesBy: "startsWith",
    options: options,
    selectedOptions: selectedOptions,
    compressed: true,
    onChange: onChange
  }));
});
exports.StackByComboBox = StackByComboBox;
StackByComboBox.displayName = 'StackByComboBox';