"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionTypeField = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../common/lib/kibana");
var _translations = require("./translations");
var _utils = require("./utils");
var _hooks = require("../../../management/components/endpoint_response_actions_list/components/hooks");
var _console_commands_definition = require("../../../management/components/endpoint_responder/lib/console_commands_definition");
var _user_privileges = require("../../../common/components/user_privileges");
var _constants = require("../../../../common/endpoint/service/response_actions/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionTypeFieldComponent = ({
  basePath,
  disabled,
  readDefaultValueOnForm
}) => {
  const {
    endpointPrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const [data] = (0, _hook_form_lib.useFormData)();
  const {
    docLinks: {
      links: {
        securitySolution: {
          responseActions
        }
      }
    }
  } = (0, _kibana.useKibana)().services;
  const fieldOptions = (0, _react.useMemo)(() => _constants.ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS.map(name => {
    const missingRbac = !(0, _console_commands_definition.getRbacControl)({
      commandName: (0, _hooks.getUiCommand)(name),
      privileges: endpointPrivileges
    });
    const commandAlreadyExists = (0, _lodash.map)(data.responseActions, 'params.command').includes(name);
    const isDisabled = commandAlreadyExists || missingRbac;
    return {
      value: name,
      inputDisplay: name,
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_utils.EndpointActionText, {
        name: name,
        isDisabled: missingRbac
      }),
      disabled: isDisabled,
      'data-test-subj': `command-type-${name}`
    };
  }), [data.responseActions, endpointPrivileges]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `${basePath}.command`,
    readDefaultValueOnForm: readDefaultValueOnForm,
    config: {
      label: _i18n.i18n.translate('xpack.securitySolution.responseActions.endpoint.commandLabel', {
        defaultMessage: 'Response action'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.responseActions.endpoint.commandDescription",
        defaultMessage: "Select an endpoint response action. The response action only runs on hosts with Elastic Defend installed. {docs}",
        values: {
          docs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: responseActions,
            target: "_blank"
          }, _translations.LEARN_MORE)
        }
      }),
      validations: [{
        validator: _helpers.fieldValidators.emptyField(_i18n.i18n.translate('xpack.securitySolution.responseActions.endpoint.validations.commandIsRequiredErrorMessage', {
          defaultMessage: 'Action is a required field.'
        }))
      }]
    },
    component: _components.SuperSelectField,
    isDisabled: disabled,
    componentProps: {
      euiFieldProps: {
        options: fieldOptions,
        placeholder: _translations.CHOOSE_FROM_THE_LIST,
        'data-test-subj': 'commandTypeField'
      }
    }
  });
};
const ActionTypeField = /*#__PURE__*/_react.default.memo(ActionTypeFieldComponent);
exports.ActionTypeField = ActionTypeField;