"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEARCH_FIRST_RULE_ANCHOR = exports.RulesManagementTour = exports.INSTALL_PREBUILT_RULES_ANCHOR = exports.GuidedOnboardingRulesStatus = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _siem_guide_config = require("../../../../../../../common/guided_onboarding/siem_guide_config");
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _kibana = require("../../../../../../common/lib/kibana");
var _use_find_rules_query = require("../../../../../rule_management/api/hooks/use_find_rules_query");
var _use_execute_bulk_action = require("../../../../../rule_management/logic/bulk_actions/use_execute_bulk_action");
var _rules_table_context = require("../rules_table_context");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_is_element_mounted = require("./use_is_element_mounted");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSTALL_PREBUILT_RULES_ANCHOR = 'install-prebuilt-rules-anchor';
exports.INSTALL_PREBUILT_RULES_ANCHOR = INSTALL_PREBUILT_RULES_ANCHOR;
const SEARCH_FIRST_RULE_ANCHOR = 'search-first-rule-anchor';
exports.SEARCH_FIRST_RULE_ANCHOR = SEARCH_FIRST_RULE_ANCHOR;
const GUIDED_ONBOARDING_RULES_FILTER = {
  filter: '',
  showCustomRules: false,
  showElasticRules: true,
  tags: ['Use Case: Guided Onboarding']
};
let GuidedOnboardingRulesStatus;
exports.GuidedOnboardingRulesStatus = GuidedOnboardingRulesStatus;
(function (GuidedOnboardingRulesStatus) {
  GuidedOnboardingRulesStatus["inactive"] = "inactive";
  GuidedOnboardingRulesStatus["installRules"] = "installRules";
  GuidedOnboardingRulesStatus["searchRules"] = "searchRules";
  GuidedOnboardingRulesStatus["enableRules"] = "enableRules";
  GuidedOnboardingRulesStatus["completed"] = "completed";
})(GuidedOnboardingRulesStatus || (exports.GuidedOnboardingRulesStatus = GuidedOnboardingRulesStatus = {}));
const RulesManagementTour = () => {
  var _guidedOnboarding$gui, _guidedOnboarding$gui2;
  const {
    guidedOnboarding
  } = (0, _kibana.useKibana)().services;
  const {
    executeBulkAction
  } = (0, _use_execute_bulk_action.useExecuteBulkAction)();
  const {
    actions
  } = (0, _rules_table_context.useRulesTableContext)();
  const isRulesStepActive = (0, _useObservable.default)((_guidedOnboarding$gui = guidedOnboarding === null || guidedOnboarding === void 0 ? void 0 : (_guidedOnboarding$gui2 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui2 === void 0 ? void 0 : _guidedOnboarding$gui2.isGuideStepActive$(_siem_guide_config.siemGuideId, 'rules')) !== null && _guidedOnboarding$gui !== void 0 ? _guidedOnboarding$gui : (0, _rxjs.of)(false), false);
  const {
    data: onboardingRules
  } = (0, _use_find_rules_query.useFindRulesQuery)({
    filterOptions: GUIDED_ONBOARDING_RULES_FILTER
  }, {
    enabled: isRulesStepActive
  });
  const demoRule = (0, _react.useMemo)(() => {
    // Rules are loading, cannot search for rule ID
    if (!(onboardingRules !== null && onboardingRules !== void 0 && onboardingRules.rules.length)) {
      return;
    }
    // Return any rule, first one is good enough
    return onboardingRules.rules[0];
  }, [onboardingRules]);
  const ruleSwitchAnchor = demoRule ? `rule-switch-${demoRule.id}` : '';

  /**
   * Wait until the tour target elements are visible on the page and mount
   * EuiTourStep components only after that. Otherwise, the tours would never
   * show up on the page.
   */
  const isInstallRulesAnchorMounted = (0, _use_is_element_mounted.useIsElementMounted)(INSTALL_PREBUILT_RULES_ANCHOR);
  const isSearchFirstRuleAnchorMounted = (0, _use_is_element_mounted.useIsElementMounted)(SEARCH_FIRST_RULE_ANCHOR);
  const isActivateFirstRuleAnchorMounted = (0, _use_is_element_mounted.useIsElementMounted)(ruleSwitchAnchor);
  const tourStatus = (0, _react.useMemo)(() => {
    if (!isRulesStepActive || !onboardingRules) {
      return GuidedOnboardingRulesStatus.inactive;
    }
    if (onboardingRules.total === 0) {
      // Onboarding rules are not installed - show the navigate to Add Rules page step
      return GuidedOnboardingRulesStatus.installRules;
    }
    if (demoRule !== null && demoRule !== void 0 && demoRule.enabled) {
      // Rules are installed and enabled - the tour is completed
      return GuidedOnboardingRulesStatus.completed;
    }

    // Rule is installed but not enabled - show the find and activate steps
    if (isActivateFirstRuleAnchorMounted) {
      // If rule is visible on the table, show the activation step
      return GuidedOnboardingRulesStatus.enableRules;
    } else {
      // If rule is not visible on the table, show the search step
      return GuidedOnboardingRulesStatus.searchRules;
    }
  }, [demoRule === null || demoRule === void 0 ? void 0 : demoRule.enabled, isActivateFirstRuleAnchorMounted, isRulesStepActive, onboardingRules]);

  // Synchronize the current "internal" tour step with the global one
  (0, _react.useEffect)(() => {
    if (isRulesStepActive && tourStatus === GuidedOnboardingRulesStatus.completed) {
      var _guidedOnboarding$gui3;
      guidedOnboarding === null || guidedOnboarding === void 0 ? void 0 : (_guidedOnboarding$gui3 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui3 === void 0 ? void 0 : _guidedOnboarding$gui3.completeGuideStep('siem', 'rules');
    }
  }, [guidedOnboarding, isRulesStepActive, tourStatus]);
  const enableDemoRule = (0, _react.useCallback)(async () => {
    if (demoRule) {
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.enable,
        ids: [demoRule.id]
      });
    }
  }, [demoRule, executeBulkAction]);
  const findDemoRule = (0, _react.useCallback)(() => {
    if (demoRule) {
      actions.setFilterOptions({
        filter: demoRule.name
      });
    }
  }, [actions, demoRule]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isInstallRulesAnchorMounted && /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    title: i18n.INSTALL_PREBUILT_RULES_TITLE,
    content: i18n.INSTALL_PREBUILT_RULES_CONTENT,
    onFinish: _lodash.noop,
    step: 1,
    stepsTotal: 3,
    isOpen: tourStatus === GuidedOnboardingRulesStatus.installRules,
    anchor: `#${INSTALL_PREBUILT_RULES_ANCHOR}`,
    anchorPosition: "downCenter",
    footerAction: /*#__PURE__*/_react.default.createElement("div", null) // Replace "Skip tour" with an empty element
  }), isSearchFirstRuleAnchorMounted && demoRule && /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    title: i18n.SEARCH_FIRST_RULE_TITLE,
    content: i18n.SEARCH_FIRST_RULE_CONTENT(demoRule.name),
    onFinish: _lodash.noop,
    step: 2,
    stepsTotal: 3,
    isOpen: tourStatus === GuidedOnboardingRulesStatus.searchRules,
    anchor: `#${SEARCH_FIRST_RULE_ANCHOR}`,
    anchorPosition: "upCenter",
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      color: "text",
      flush: "right",
      onClick: findDemoRule
    }, i18n.NEXT_BUTTON)
  }), isActivateFirstRuleAnchorMounted && demoRule && /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    title: i18n.ENABLE_FIRST_RULE_TITLE,
    content: i18n.ENABLE_FIRST_RULE_CONTENT(demoRule.name),
    onFinish: _lodash.noop,
    step: 3,
    stepsTotal: 3,
    isOpen: tourStatus === GuidedOnboardingRulesStatus.enableRules,
    anchor: `#${ruleSwitchAnchor}`,
    anchorPosition: "upCenter",
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      color: "text",
      flush: "right",
      onClick: enableDemoRule
    }, i18n.NEXT_BUTTON)
  }));
};
exports.RulesManagementTour = RulesManagementTour;