"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.computeDryRunEditPayload = computeDryRunEditPayload;
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _utility_types = require("../../../../../../../common/utility_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * helper utility that creates payload for _bulk_action API in dry mode
 * @param {BulkAction} action
 * @param {BulkActionEditType | undefined} editAction
 * @returns {BulkActionEditPayload[] | undefined}
 */
function computeDryRunEditPayload(editAction) {
  switch (editAction) {
    case _rule_management.BulkActionEditTypeEnum.add_index_patterns:
    case _rule_management.BulkActionEditTypeEnum.delete_index_patterns:
    case _rule_management.BulkActionEditTypeEnum.set_index_patterns:
      return [{
        type: editAction,
        value: []
      }];
    case _rule_management.BulkActionEditTypeEnum.add_tags:
    case _rule_management.BulkActionEditTypeEnum.delete_tags:
    case _rule_management.BulkActionEditTypeEnum.set_tags:
      return [{
        type: editAction,
        value: []
      }];
    case _rule_management.BulkActionEditTypeEnum.set_timeline:
      return [{
        type: editAction,
        value: {
          timeline_id: '',
          timeline_title: ''
        }
      }];
    case _rule_management.BulkActionEditTypeEnum.add_rule_actions:
    case _rule_management.BulkActionEditTypeEnum.set_rule_actions:
      return [{
        type: editAction,
        value: {
          actions: []
        }
      }];
    case _rule_management.BulkActionEditTypeEnum.set_schedule:
      return [{
        type: editAction,
        value: {
          interval: '5m',
          lookback: '1m'
        }
      }];
    default:
      (0, _utility_types.assertUnreachable)(editAction);
  }
  return [{
    type: editAction,
    value: []
  }];
}