"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUpdateRulesCalloutTitle = exports.RULE_UPDATES_LINK = exports.NEW_PREBUILT_RULES_AVAILABLE_CALLOUT_TITLE = exports.DISMISS = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DISMISS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.dismissTitle', {
  defaultMessage: 'Dismiss'
});
exports.DISMISS = DISMISS;
const NEW_PREBUILT_RULES_AVAILABLE_CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.newPrebuiltRulesCalloutTitle', {
  defaultMessage: 'New Elastic rules are available to be installed. Click on the “Add Elastic Rules” button to Review and install.'
});
exports.NEW_PREBUILT_RULES_AVAILABLE_CALLOUT_TITLE = NEW_PREBUILT_RULES_AVAILABLE_CALLOUT_TITLE;
const RULE_UPDATES_LINK = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.ruleUpdatesLinkTitle', {
  defaultMessage: 'Rule Updates'
});
exports.RULE_UPDATES_LINK = RULE_UPDATES_LINK;
const getUpdateRulesCalloutTitle = onClick => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.rules.updatePrebuiltRulesCalloutTitle",
  defaultMessage: "Updates available for installed rules. Review and update in\xA0{link}.",
  values: {
    link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      className: (0, _css.css)`
            font-weight: 400;
          `,
      onClick: onClick
    }, RULE_UPDATES_LINK)
  }
});
exports.getUpdateRulesCalloutTitle = getUpdateRulesCalloutTitle;