"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleWithFallback = exports.transformRuleFromAlertHit = exports.migrateRuleWithLegacyInvestigationFieldsFromAlertHit = exports.migrateLegacyInvestigationFields = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _react = require("react");
var _expand_dotted = require("../../../../common/utils/expand_dotted");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _constants = require("../../../detections/containers/detection_engine/alerts/constants");
var _use_query = require("../../../detections/containers/detection_engine/alerts/use_query");
var _transforms = require("../../../detections/containers/detection_engine/rules/transforms");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_rule = require("./use_rule");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: Create proper types for nested/flattened RACRule once contract w/ Fields API is finalized.

const buildLastAlertQuery = ruleId => ({
  query: {
    bool: {
      filter: [{
        bool: {
          should: [{
            match: {
              'signal.rule.id': ruleId
            }
          }, {
            match: {
              [_ruleDataUtils.ALERT_RULE_UUID]: ruleId
            }
          }],
          minimum_should_match: 1
        }
      }]
    }
  },
  size: 1
});

/**
 * We try to fetch the rule first. If the request fails with 404, that could mean that the rule was deleted.
 * In that case, try to fetch the latest alert generated by the rule and retrieve the rule data from the alert (fallback).
 */
const useRuleWithFallback = ruleId => {
  const {
    isFetching: ruleLoading,
    data: ruleData,
    error,
    refetch
  } = (0, _use_rule.useRule)(ruleId, false);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const isExistingRule = !(0, _securitysolutionTGrid.isNotFoundError)(error);
  const {
    loading: alertsLoading,
    data: alertsData
  } = (0, _use_query.useQueryAlerts)({
    query: buildLastAlertQuery(ruleId),
    skip: isExistingRule,
    queryName: _constants.ALERTS_QUERY_NAMES.BY_RULE_ID
  });
  (0, _react.useEffect)(() => {
    if (error != null && !(0, _securitysolutionTGrid.isNotFoundError)(error)) {
      addError(error, {
        title: i18n.RULE_AND_TIMELINE_FETCH_FAILURE
      });
    }
  }, [addError, error]);
  const rule = (0, _react.useMemo)(() => {
    const result = isExistingRule ? ruleData : alertsData == null ? undefined : transformRuleFromAlertHit(alertsData);
    if (result) {
      return (0, _transforms.transformInput)(result);
    }
  }, [isExistingRule, alertsData, ruleData]);
  return {
    error,
    loading: ruleLoading || alertsLoading,
    refresh: refetch,
    rule: rule !== null && rule !== void 0 ? rule : null,
    isExistingRule
  };
};

/**
 * In 8.10.x investigation_fields is mapped as alert, moving forward, it will be mapped
 * as an object. This util is being used for the use case where a rule is deleted and the
 * hook falls back to using the alert document to retrieve rule information. In this scenario
 * we are going to return undefined if field is in legacy format to avoid any possible complexity
 * in the UI for such flows. See PR 169061
 * @param investigationFields InvestigationFieldsCombined | undefined
 * @returns InvestigationFields | undefined
 */
exports.useRuleWithFallback = useRuleWithFallback;
const migrateLegacyInvestigationFields = investigationFields => {
  if (investigationFields && Array.isArray(investigationFields)) {
    return undefined;
  }
  return investigationFields;
};

/**
 * In 8.10.x investigation_fields is mapped as alert, moving forward, it will be mapped
 * as an object. This util is being used for the use case where a rule is deleted and the
 * hook falls back to using the alert document to retrieve rule information. In this scenario
 * we are going to return undefined if field is in legacy format to avoid any possible complexity
 * in the UI for such flows. See PR 169061
 * @param rule Rule
 * @returns Rule
 */
exports.migrateLegacyInvestigationFields = migrateLegacyInvestigationFields;
const migrateRuleWithLegacyInvestigationFieldsFromAlertHit = rule => {
  if (!rule) return rule;
  return {
    ...rule,
    investigation_fields: migrateLegacyInvestigationFields(rule.investigation_fields)
  };
};

/**
 * Transforms an alertHit into a Rule
 * @param data raw response containing single alert
 */
exports.migrateRuleWithLegacyInvestigationFieldsFromAlertHit = migrateRuleWithLegacyInvestigationFieldsFromAlertHit;
const transformRuleFromAlertHit = data => {
  var _hit$_source$signal$r, _hit$_source$signal, _hit$_source$kibana, _hit$_source$kibana$a;
  // if results empty, return rule as undefined
  if (data.hits.hits.length === 0) {
    return undefined;
  }
  const hit = data.hits.hits[0];

  // If pre 8.x alert, pull directly from alertHit
  const rule = (_hit$_source$signal$r = (_hit$_source$signal = hit._source.signal) === null || _hit$_source$signal === void 0 ? void 0 : _hit$_source$signal.rule) !== null && _hit$_source$signal$r !== void 0 ? _hit$_source$signal$r : (_hit$_source$kibana = hit._source.kibana) === null || _hit$_source$kibana === void 0 ? void 0 : (_hit$_source$kibana$a = _hit$_source$kibana.alert) === null || _hit$_source$kibana$a === void 0 ? void 0 : _hit$_source$kibana$a.rule;

  // If rule undefined, response likely flattened
  if (rule == null) {
    var _hit$_source, _expandedRuleWithPara, _expandedRuleWithPara2, _expandedRuleWithPara3, _expandedRuleWithPara4, _expandedRuleWithPara5;
    const expandedRuleWithParams = (0, _expand_dotted.expandDottedObject)((_hit$_source = hit._source) !== null && _hit$_source !== void 0 ? _hit$_source : {});
    const expandedRule = {
      ...(expandedRuleWithParams === null || expandedRuleWithParams === void 0 ? void 0 : (_expandedRuleWithPara = expandedRuleWithParams.kibana) === null || _expandedRuleWithPara === void 0 ? void 0 : (_expandedRuleWithPara2 = _expandedRuleWithPara.alert) === null || _expandedRuleWithPara2 === void 0 ? void 0 : _expandedRuleWithPara2.rule),
      ...(expandedRuleWithParams === null || expandedRuleWithParams === void 0 ? void 0 : (_expandedRuleWithPara3 = expandedRuleWithParams.kibana) === null || _expandedRuleWithPara3 === void 0 ? void 0 : (_expandedRuleWithPara4 = _expandedRuleWithPara3.alert) === null || _expandedRuleWithPara4 === void 0 ? void 0 : (_expandedRuleWithPara5 = _expandedRuleWithPara4.rule) === null || _expandedRuleWithPara5 === void 0 ? void 0 : _expandedRuleWithPara5.parameters)
    };
    delete expandedRule.parameters;
    return migrateRuleWithLegacyInvestigationFieldsFromAlertHit(expandedRule);
  }
  return migrateRuleWithLegacyInvestigationFieldsFromAlertHit(rule);
};
exports.transformRuleFromAlertHit = transformRuleFromAlertHit;