"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.explainBulkEditSuccess = explainBulkEditSuccess;
exports.explainBulkError = explainBulkError;
exports.explainBulkSuccess = explainBulkSuccess;
exports.summarizeBulkError = summarizeBulkError;
exports.summarizeBulkSuccess = summarizeBulkSuccess;
var _rule_management = require("../../../../../common/api/detection_engine/rule_management");
var i18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/rules/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function summarizeBulkSuccess(action) {
  switch (action) {
    case _rule_management.BulkActionTypeEnum.export:
      return i18n.RULES_BULK_EXPORT_SUCCESS;
    case _rule_management.BulkActionTypeEnum.duplicate:
      return i18n.RULES_BULK_DUPLICATE_SUCCESS;
    case _rule_management.BulkActionTypeEnum.delete:
      return i18n.RULES_BULK_DELETE_SUCCESS;
    case _rule_management.BulkActionTypeEnum.enable:
      return i18n.RULES_BULK_ENABLE_SUCCESS;
    case _rule_management.BulkActionTypeEnum.disable:
      return i18n.RULES_BULK_DISABLE_SUCCESS;
    case _rule_management.BulkActionTypeEnum.edit:
      return i18n.RULES_BULK_EDIT_SUCCESS;
  }
}
function explainBulkSuccess(action, summary) {
  switch (action) {
    case _rule_management.BulkActionTypeEnum.export:
      return getExportSuccessToastMessage(summary.succeeded, summary.total);
    case _rule_management.BulkActionTypeEnum.duplicate:
      return i18n.RULES_BULK_DUPLICATE_SUCCESS_DESCRIPTION(summary.succeeded);
    case _rule_management.BulkActionTypeEnum.delete:
      return i18n.RULES_BULK_DELETE_SUCCESS_DESCRIPTION(summary.succeeded);
    case _rule_management.BulkActionTypeEnum.enable:
      return i18n.RULES_BULK_ENABLE_SUCCESS_DESCRIPTION(summary.succeeded);
    case _rule_management.BulkActionTypeEnum.disable:
      return i18n.RULES_BULK_DISABLE_SUCCESS_DESCRIPTION(summary.succeeded);
  }
}
function explainBulkEditSuccess(editPayload, summary) {
  const dataViewSkipDetail = summary.skipped > 0 ? ` ${i18n.RULES_BULK_EDIT_SUCCESS_DATA_VIEW_RULES_SKIPPED_DETAIL}` : null;
  if (editPayload.some(x => x.type === _rule_management.BulkActionEditTypeEnum.add_index_patterns || x.type === _rule_management.BulkActionEditTypeEnum.set_index_patterns || x.type === _rule_management.BulkActionEditTypeEnum.delete_index_patterns)) {
    return `${i18n.RULES_BULK_EDIT_SUCCESS_DESCRIPTION(summary.succeeded, summary.skipped)}${dataViewSkipDetail}`;
  }
  return i18n.RULES_BULK_EDIT_SUCCESS_DESCRIPTION(summary.succeeded, summary.skipped);
}
function summarizeBulkError(action) {
  switch (action) {
    case _rule_management.BulkActionTypeEnum.export:
      return i18n.RULES_BULK_EXPORT_FAILURE;
    case _rule_management.BulkActionTypeEnum.duplicate:
      return i18n.RULES_BULK_DUPLICATE_FAILURE;
    case _rule_management.BulkActionTypeEnum.delete:
      return i18n.RULES_BULK_DELETE_FAILURE;
    case _rule_management.BulkActionTypeEnum.enable:
      return i18n.RULES_BULK_ENABLE_FAILURE;
    case _rule_management.BulkActionTypeEnum.disable:
      return i18n.RULES_BULK_DISABLE_FAILURE;
    case _rule_management.BulkActionTypeEnum.edit:
      return i18n.RULES_BULK_EDIT_FAILURE;
  }
}
function explainBulkError(action, error) {
  var _error$body, _error$body$attribute;
  // if response doesn't have number of failed rules, it means the whole bulk action failed
  const summary = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : (_error$body$attribute = _error$body.attributes) === null || _error$body$attribute === void 0 ? void 0 : _error$body$attribute.summary;
  if (!summary) {
    return '';
  }
  switch (action) {
    case _rule_management.BulkActionTypeEnum.export:
      return i18n.RULES_BULK_EXPORT_FAILURE_DESCRIPTION(summary.failed);
    case _rule_management.BulkActionTypeEnum.duplicate:
      return i18n.RULES_BULK_DUPLICATE_FAILURE_DESCRIPTION(summary.failed);
    case _rule_management.BulkActionTypeEnum.delete:
      return i18n.RULES_BULK_DELETE_FAILURE_DESCRIPTION(summary.failed);
    case _rule_management.BulkActionTypeEnum.enable:
      return i18n.RULES_BULK_ENABLE_FAILURE_DESCRIPTION(summary.failed);
    case _rule_management.BulkActionTypeEnum.disable:
      return i18n.RULES_BULK_DISABLE_FAILURE_DESCRIPTION(summary.failed);
    case _rule_management.BulkActionTypeEnum.edit:
      return i18n.RULES_BULK_EDIT_FAILURE_DESCRIPTION(summary.failed, summary.skipped);
  }
}
const getExportSuccessToastMessage = (succeeded, total) => {
  const message = [i18n.RULES_BULK_EXPORT_SUCCESS_DESCRIPTION(succeeded, total)];

  // if not all rules are successfully exported it means there included prebuilt rules
  // display message to users that prebuilt rules were excluded
  if (total > succeeded) {
    message.push(i18n.RULES_BULK_EXPORT_PREBUILT_RULES_EXCLUDED_DESCRIPTION);
  }
  return message.join(' ');
};