"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Hunks = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDiffView = require("react-diff-view");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UnfoldButton = ({
  start,
  end,
  onExpand,
  ...props
}) => {
  const expand = (0, _react.useCallback)(() => onExpand(start, end), [onExpand, start, end]);
  const linesCount = end - start;
  return /*#__PURE__*/_react.default.createElement(_reactDiffView.Decoration, props, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, start > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: expand
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortable"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, i18n.EXPAND_UNCHANGED_LINES(linesCount))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })));
};
const UnfoldCollapsed = ({
  previousHunk,
  currentHunk,
  linesCount,
  onExpand
}) => {
  if (!currentHunk) {
    const nextStart = previousHunk.oldStart + previousHunk.oldLines;
    const collapsedLines = linesCount - nextStart + 1;
    if (collapsedLines <= 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(UnfoldButton, {
      start: nextStart,
      end: linesCount + 1,
      onExpand: onExpand
    });
  }
  const collapsedLines = (0, _reactDiffView.getCollapsedLinesCountBetween)(previousHunk, currentHunk);
  if (!previousHunk) {
    if (!collapsedLines) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(UnfoldButton, {
      start: 1,
      end: currentHunk.oldStart,
      onExpand: onExpand
    });
  }
  const collapsedStart = previousHunk.oldStart + previousHunk.oldLines;
  const collapsedEnd = currentHunk.oldStart;
  return /*#__PURE__*/_react.default.createElement(UnfoldButton, {
    start: collapsedStart,
    end: collapsedEnd,
    onExpand: onExpand
  });
};
const Hunks = ({
  hunks,
  oldSource,
  expandRange
}) => {
  const linesCount = oldSource.split('\n').length;
  const hunkElements = hunks.reduce((children, hunk, index) => {
    const previousElement = children[children.length - 1];
    children.push( /*#__PURE__*/_react.default.createElement(UnfoldCollapsed, {
      key: `decoration-${hunk.content}`,
      previousHunk: previousElement && previousElement.props.hunk,
      currentHunk: hunk,
      linesCount: linesCount,
      onExpand: expandRange
    }));
    children.push( /*#__PURE__*/_react.default.createElement(_reactDiffView.Hunk, {
      key: `hunk-${hunk.content}`,
      hunk: hunk
    }));
    const isLastHunk = index === hunks.length - 1;
    if (isLastHunk && oldSource) {
      children.push( /*#__PURE__*/_react.default.createElement(UnfoldCollapsed, {
        key: "decoration-tail",
        previousHunk: hunk,
        linesCount: linesCount,
        onExpand: expandRange
      }));
    }
    return children;
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hunkElements);
};
exports.Hunks = Hunks;