"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateFetchCoverageOverviewQuery = exports.useFetchCoverageOverviewQuery = void 0;
var _reactQuery = require("@tanstack/react-query");
var _react = require("react");
var i18n = _interopRequireWildcard(require("../../../rule_management_ui/pages/coverage_overview/translations"));
var _detection_engine = require("../../../../../common/api/detection_engine");
var _api = require("../api");
var _build_coverage_overview_dashboard_model = require("../../logic/coverage_overview/build_coverage_overview_dashboard_model");
var _constants = require("./constants");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COVERAGE_OVERVIEW_QUERY_KEY = ['POST', _detection_engine.RULE_MANAGEMENT_COVERAGE_OVERVIEW_URL];

/**
 * A wrapper around useQuery provides default values to the underlying query,
 * like query key, abortion signal, and error handler.
 *
 * @param filter - coverage overview filter, see CoverageOverviewFilter type
 * @param options - react-query options
 * @returns useQuery result
 */
const useFetchCoverageOverviewQuery = (filter = {}, options) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _reactQuery.useQuery)([...COVERAGE_OVERVIEW_QUERY_KEY, filter], async ({
    signal
  }) => {
    const response = await (0, _api.fetchCoverageOverview)({
      signal,
      filter
    });
    return (0, _build_coverage_overview_dashboard_model.buildCoverageOverviewDashboardModel)(response);
  }, {
    ..._constants.DEFAULT_QUERY_OPTIONS,
    ...options,
    onError: error => {
      addError(error, {
        title: i18n.COVERAGE_OVERVIEW_FETCH_ERROR_TITLE
      });
    }
  });
};

/**
 * We should use this hook to invalidate the coverage overview cache. For example, rule
 * mutations that affect rule set size, like creation or deletion, should lead
 * to cache invalidation.
 *
 * @returns A coverage overview cache invalidation callback
 */
exports.useFetchCoverageOverviewQuery = useFetchCoverageOverviewQuery;
const useInvalidateFetchCoverageOverviewQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(COVERAGE_OVERVIEW_QUERY_KEY, {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateFetchCoverageOverviewQuery = useInvalidateFetchCoverageOverviewQuery;