"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkInstallFleetPackagesMutation = exports.BULK_INSTALL_FLEET_PACKAGES_MUTATION_KEY = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../../../common/detection_engine/constants");
var _api = require("../api");
var _use_fetch_prebuilt_rules_install_review_query = require("./prebuilt_rules/use_fetch_prebuilt_rules_install_review_query");
var _use_fetch_prebuilt_rules_status_query = require("./prebuilt_rules/use_fetch_prebuilt_rules_status_query");
var _use_fetch_prebuilt_rules_upgrade_review_query = require("./prebuilt_rules/use_fetch_prebuilt_rules_upgrade_review_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BULK_INSTALL_FLEET_PACKAGES_MUTATION_KEY = ['POST', _common.EPM_API_ROUTES.BULK_INSTALL_PATTERN];
exports.BULK_INSTALL_FLEET_PACKAGES_MUTATION_KEY = BULK_INSTALL_FLEET_PACKAGES_MUTATION_KEY;
const useBulkInstallFleetPackagesMutation = options => {
  const invalidatePrePackagedRulesStatus = (0, _use_fetch_prebuilt_rules_status_query.useInvalidateFetchPrebuiltRulesStatusQuery)();
  const invalidatePrebuiltRulesInstallReview = (0, _use_fetch_prebuilt_rules_install_review_query.useInvalidateFetchPrebuiltRulesInstallReviewQuery)();
  const invalidatePrebuiltRulesUpdateReview = (0, _use_fetch_prebuilt_rules_upgrade_review_query.useInvalidateFetchPrebuiltRulesUpgradeReviewQuery)();
  return (0, _reactQuery.useMutation)(props => (0, _api.bulkInstallFleetPackages)(props), {
    ...options,
    mutationKey: BULK_INSTALL_FLEET_PACKAGES_MUTATION_KEY,
    onSettled: (...args) => {
      const response = args[0];
      const rulesPackage = response === null || response === void 0 ? void 0 : response.items.find(item => item.name === _constants.PREBUILT_RULES_PACKAGE_NAME);
      if (rulesPackage && 'result' in rulesPackage && rulesPackage.result.status === 'installed') {
        // The rules package was installed/updated, so invalidate the pre-packaged rules status query
        invalidatePrePackagedRulesStatus();
        invalidatePrebuiltRulesInstallReview();
        invalidatePrebuiltRulesUpdateReview();
      }
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    }
  });
};
exports.useBulkInstallFleetPackagesMutation = useBulkInstallFleetPackagesMutation;