"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createExceptionItemsReducer = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createExceptionItemsReducer = () => (state, action) => {
  switch (action.type) {
    case 'setExceptionItemMeta':
      {
        const {
          value
        } = action;
        return {
          ...state,
          exceptionItemMeta: {
            ...state.exceptionItemMeta,
            [value[0]]: value[1]
          }
        };
      }
    case 'setComment':
      {
        const {
          comment
        } = action;
        return {
          ...state,
          newComment: comment
        };
      }
    case 'setCommentError':
      {
        const {
          errorExists
        } = action;
        return {
          ...state,
          commentErrorExists: errorExists
        };
      }
    case 'setBulkCloseAlerts':
      {
        const {
          bulkClose
        } = action;
        return {
          ...state,
          bulkCloseAlerts: bulkClose
        };
      }
    case 'setDisableBulkCloseAlerts':
      {
        const {
          disableBulkCloseAlerts
        } = action;
        return {
          ...state,
          disableBulkClose: disableBulkCloseAlerts
        };
      }
    case 'setBulkCloseIndex':
      {
        const {
          bulkCloseIndex
        } = action;
        return {
          ...state,
          bulkCloseIndex
        };
      }
    case 'setExceptionItems':
      {
        const {
          items
        } = action;
        return {
          ...state,
          exceptionItems: items
        };
      }
    case 'setConditionValidationErrorExists':
      {
        const {
          errorExists
        } = action;
        return {
          ...state,
          entryErrorExists: errorExists
        };
      }
    case 'setExpireTime':
      {
        const {
          expireTime
        } = action;
        return {
          ...state,
          expireTime
        };
      }
    case 'setExpireError':
      {
        const {
          errorExists
        } = action;
        return {
          ...state,
          expireErrorExists: errorExists
        };
      }
    default:
      return state;
  }
};
exports.createExceptionItemsReducer = createExceptionItemsReducer;