"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUCCESSFULLY_SAVED_RULE = exports.SORRY_ERRORS = exports.SAVE_CHANGES = exports.PAGE_TITLE = exports.CANCEL = exports.BACK_TO = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.editRule.pageTitle', {
  defaultMessage: 'Edit rule settings'
});
exports.PAGE_TITLE = PAGE_TITLE;
const CANCEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.editRule.cancelTitle', {
  defaultMessage: 'Cancel'
});
exports.CANCEL = CANCEL;
const SAVE_CHANGES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.editRule.saveChangeTitle', {
  defaultMessage: 'Save changes'
});
exports.SAVE_CHANGES = SAVE_CHANGES;
const SORRY_ERRORS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.editRule.errorMsgDescription', {
  defaultMessage: 'Sorry'
});
exports.SORRY_ERRORS = SORRY_ERRORS;
const BACK_TO = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.editRule.backToDescription', {
  defaultMessage: 'Back to'
});
exports.BACK_TO = BACK_TO;
const SUCCESSFULLY_SAVED_RULE = ruleName => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.update.successfullySavedRuleTitle', {
  values: {
    ruleName
  },
  defaultMessage: '{ruleName} was saved'
});
exports.SUCCESSFULLY_SAVED_RULE = SUCCESSFULLY_SAVED_RULE;