"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomHeaderPageMemo = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _header_page = require("../../../common/components/header_page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomHeaderPage = ({
  backOptions,
  isLoading,
  title,
  togglePanel,
  isRulePreviewVisible,
  setIsRulePreviewVisible
}) => /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
  backOptions: backOptions,
  isLoading: isLoading,
  title: title
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  "data-test-subj": "preview-container",
  isSelected: isRulePreviewVisible,
  fill: isRulePreviewVisible,
  iconType: "visBarVerticalStacked",
  onClick: () => {
    togglePanel === null || togglePanel === void 0 ? void 0 : togglePanel('preview', {
      direction: 'left'
    });
    setIsRulePreviewVisible(isVisible => !isVisible);
  }
}, i18n.RULE_PREVIEW_TITLE));
const CustomHeaderPageMemo = /*#__PURE__*/(0, _react.memo)(CustomHeaderPage);
exports.CustomHeaderPageMemo = CustomHeaderPageMemo;