"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEsqlIndex = void 0;
var _react = require("react");
var _esQuery = require("@kbn/es-query");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _utils = require("../../../../common/detection_engine/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * parses ES|QL query and returns memoized array of indices
 * @param query - ES|QL query to retrieve index from
 * @param ruleType - rule type value
 * @param isQueryReadEnabled - if not enabled, return empty array. Useful if we know form or query is not valid and we don't want to retrieve index
 * @returns
 */
const useEsqlIndex = (query, ruleType, isQueryReadEnabled) => {
  const indexString = (0, _react.useMemo)(() => {
    if (!isQueryReadEnabled) {
      return '';
    }
    const esqlQuery = typeof query === 'string' && (0, _utils.isEsqlRule)(ruleType) ? query : undefined;
    return (0, _esQuery.getIndexPatternFromESQLQuery)(esqlQuery);
  }, [query, isQueryReadEnabled, ruleType]);
  const index = (0, _react.useMemo)(() => (0, _securitysolutionUtils.getIndexListFromIndexString)(indexString), [indexString]);
  return index;
};
exports.useEsqlIndex = useEsqlIndex;