"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsEsqlRuleTypeEnabled = void 0;
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsEsqlRuleTypeEnabled = () => {
  const isEsqlSettingEnabled = (0, _kibana.useKibana)().services.configSettings.ESQLEnabled;
  const isEsqlRuleTypeEnabled = !(0, _use_experimental_features.useIsExperimentalFeatureEnabled)('esqlRulesDisabled');
  return isEsqlSettingEnabled && isEsqlRuleTypeEnabled;
};
exports.useIsEsqlRuleTypeEnabled = useIsEsqlRuleTypeEnabled;