"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardsContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/embeddable-plugin/public");
var _landing_page = require("./landing_page");
var _details = require("./details");
var _constants = require("../../../common/constants");
var _dashboard_context = require("../context/dashboard_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DashboardsContainerComponent = () => {
  return /*#__PURE__*/_react.default.createElement(_dashboard_context.DashboardContextProvider, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    strict: true,
    path: `${_constants.DASHBOARDS_PATH}/create`
  }, /*#__PURE__*/_react.default.createElement(_details.DashboardView, {
    initialViewMode: _public.ViewMode.EDIT
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    strict: true,
    path: `${_constants.DASHBOARDS_PATH}/:detailName/edit`
  }, /*#__PURE__*/_react.default.createElement(_details.DashboardView, {
    initialViewMode: _public.ViewMode.EDIT
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    strict: true,
    path: `${_constants.DASHBOARDS_PATH}/:detailName`
  }, /*#__PURE__*/_react.default.createElement(_details.DashboardView, {
    initialViewMode: _public.ViewMode.VIEW
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.DASHBOARDS_PATH}`
  }, /*#__PURE__*/_react.default.createElement(_landing_page.DashboardsLandingPage, null))));
};
const DashboardsContainer = /*#__PURE__*/_react.default.memo(DashboardsContainerComponent);
exports.DashboardsContainer = DashboardsContainer;