"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSetFieldValueWithCallback = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSetFieldValueWithCallback = ({
  field,
  setFieldValue,
  value
}) => {
  const isWaitingRef = (0, _react.useRef)(false);
  const valueRef = (0, _react.useRef)();
  const [callback, setCallback] = (0, _react.useState)(() => null);
  (0, _react.useEffect)(() => {
    if (isWaitingRef.current && value === valueRef.current) {
      isWaitingRef.current = false;
      valueRef.current = undefined;
      callback();
    }
  }, [value, callback]);
  return (0, _react.useCallback)((v, cb) => {
    setFieldValue(field, v);
    setCallback(() => cb);
    valueRef.current = v;
    isWaitingRef.current = true;
  }, [field, setFieldValue]);
};
exports.useSetFieldValueWithCallback = useSetFieldValueWithCallback;