"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.globalNode = exports.SUB_PLUGINS_REDUCER = void 0;
var _store = require("../../explore/hosts/store");
var _store2 = require("../../explore/network/store");
var _store3 = require("../../explore/users/store");
var _reducer = require("../../timelines/store/timeline/reducer");
var _reducer2 = require("../../management/store/reducer");
var _mock_local_storage = require("./mock_local_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const globalNode = global;
exports.globalNode = globalNode;
const {
  storage
} = (0, _mock_local_storage.createSecuritySolutionStorageMock)();
const SUB_PLUGINS_REDUCER = {
  hosts: _store.hostsReducer,
  network: _store2.networkReducer,
  users: (0, _store3.makeUsersReducer)(storage),
  timeline: _reducer.timelineReducer,
  /**
   * These state's are wrapped in `Immutable`, but for compatibility with the overall app architecture,
   * they are cast to mutable versions here.
   */
  management: _reducer2.managementReducer
};
exports.SUB_PLUGINS_REDUCER = SUB_PLUGINS_REDUCER;