"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityRiskFilteredEvent = exports.entityClickedEvent = exports.entityAlertsClickedEvent = void 0;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entityClickedEvent = {
  eventType: _constants.TelemetryEventTypes.EntityDetailsClicked,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    }
  }
};
exports.entityClickedEvent = entityClickedEvent;
const entityAlertsClickedEvent = {
  eventType: _constants.TelemetryEventTypes.EntityAlertsClicked,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    }
  }
};
exports.entityAlertsClickedEvent = entityAlertsClickedEvent;
const entityRiskFilteredEvent = {
  eventType: _constants.TelemetryEventTypes.EntityRiskFiltered,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    },
    selectedSeverity: {
      type: 'keyword',
      _meta: {
        description: 'Selected severity (Unknown|Low|Moderate|High|Critical)',
        optional: false
      }
    }
  }
};
exports.entityRiskFilteredEvent = entityRiskFilteredEvent;