"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unIsolateHost = exports.isolateHost = void 0;
var _kibana = require("../kibana");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Isolates a Host running either elastic endpoint or fleet agent */
const isolateHost = async params => {
  return _kibana.KibanaServices.get().http.post(_constants.ISOLATE_HOST_ROUTE_V2, {
    body: JSON.stringify(params),
    version: '2023-10-31'
  });
};

/** Un-isolates a Host running either elastic endpoint or fleet agent */
exports.isolateHost = isolateHost;
const unIsolateHost = async params => {
  return _kibana.KibanaServices.get().http.post(_constants.UNISOLATE_HOST_ROUTE_V2, {
    body: JSON.stringify(params),
    version: '2023-10-31'
  });
};
exports.unIsolateHost = unIsolateHost;