"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldValueCell = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _data_driven_columns = require("../../../timelines/components/timeline/body/data_driven_columns");
var _formatted_field = require("../../../timelines/components/timeline/body/renderers/formatted_field");
var _parse_value = require("../../../timelines/components/timeline/body/renderers/parse_value");
var _helpers = require("./helpers");
var _helpers2 = require("../../../helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFormattedFieldProps = ({
  rowIndex,
  pageSize,
  ecsData,
  columnId,
  header,
  data
}) => {
  var _id;
  const pageRowIndex = (0, _securitysolutionDataTable.getPageRowIndex)(rowIndex, pageSize);
  const ecs = ecsData[pageRowIndex];
  const link = (0, _helpers.getLinkColumnDefinition)(columnId, header === null || header === void 0 ? void 0 : header.type, header === null || header === void 0 ? void 0 : header.linkField);
  const linkField = header !== null && header !== void 0 && header.linkField ? header === null || header === void 0 ? void 0 : header.linkField : link === null || link === void 0 ? void 0 : link.linkField;
  const linkValues = header && (0, _fp.getOr)([], linkField !== null && linkField !== void 0 ? linkField : '', ecs);
  const eventId = header && (0, _fp.get)((_id = '_id') !== null && _id !== void 0 ? _id : '', ecs) || '';
  const rowData = (0, _react.useMemo)(() => {
    return {
      data: data[pageRowIndex],
      fieldName: columnId
    };
  }, [pageRowIndex, columnId, data]);
  const values = (0, _data_driven_columns.useGetMappedNonEcsValue)(rowData);
  const value = (0, _parse_value.parseValue)((0, _fp.head)(values));
  const title = values && values.length > 1 ? `${link === null || link === void 0 ? void 0 : link.label}: ${value}` : link === null || link === void 0 ? void 0 : link.label;
  // if linkField is defined but link values is empty, it's possible we are trying to look for a column definition for an old event set
  if (linkField !== undefined && linkValues.length === 0 && values !== undefined) {
    const normalizedLinkValue = (0, _helpers2.getField)(ecs, linkField);
    const normalizedLinkField = (0, _helpers2.getFieldKey)(ecs, linkField);
    const normalizedColumnId = (0, _helpers2.getFieldKey)(ecs, columnId);
    const normalizedLink = (0, _helpers.getLinkColumnDefinition)(normalizedColumnId, header === null || header === void 0 ? void 0 : header.type, normalizedLinkField);
    return {
      pageRowIndex,
      link: normalizedLink,
      eventId,
      fieldFormat: (header === null || header === void 0 ? void 0 : header.format) || '',
      fieldName: normalizedColumnId,
      fieldType: (header === null || header === void 0 ? void 0 : header.type) || '',
      value: (0, _parse_value.parseValue)((0, _fp.head)(normalizedColumnId)),
      values,
      title,
      linkValue: (0, _fp.head)(normalizedLinkValue)
    };
  } else {
    return {
      pageRowIndex,
      link,
      eventId,
      fieldFormat: (header === null || header === void 0 ? void 0 : header.format) || '',
      fieldName: columnId,
      fieldType: (header === null || header === void 0 ? void 0 : header.type) || '',
      value,
      values,
      title,
      linkValue: (0, _fp.head)(linkValues)
    };
  }
};
const FieldValueCell = ({
  data,
  ecsData,
  header,
  scopeId,
  pageSize,
  closeCellPopover
}) => {
  if (header !== undefined) {
    return function FieldValue({
      rowIndex,
      columnId,
      Component
    }) {
      var _header$aggregatable;
      const {
        pageRowIndex,
        link,
        eventId,
        value,
        values,
        title,
        fieldName,
        fieldFormat,
        fieldType,
        linkValue
      } = useFormattedFieldProps({
        rowIndex,
        pageSize,
        ecsData,
        columnId,
        header,
        data
      });
      const showEmpty = (0, _react.useMemo)(() => {
        const hasLink = link !== undefined && values && !(0, _fp.isEmpty)(value);
        if (pageRowIndex >= data.length) {
          return true;
        } else {
          return hasLink !== true;
        }
      }, [link, pageRowIndex, value, values]);
      return showEmpty === false ? /*#__PURE__*/_react.default.createElement(_formatted_field.FormattedFieldValue, {
        Component: Component,
        contextId: `expanded-value-${columnId}-row-${pageRowIndex}-${scopeId}`,
        eventId: eventId,
        fieldFormat: fieldFormat,
        isAggregatable: (_header$aggregatable = header.aggregatable) !== null && _header$aggregatable !== void 0 ? _header$aggregatable : false,
        fieldName: fieldName,
        fieldType: fieldType,
        isButton: true,
        isDraggable: false,
        value: value,
        truncate: false,
        title: title,
        linkValue: linkValue,
        onClick: closeCellPopover
      }) :
      // data grid expects each cell action always return an element, it crashes if returns null
      _helpers.EmptyComponent;
    };
  } else {
    return _helpers.EmptyComponent;
  }
};
exports.FieldValueCell = FieldValueCell;