"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCopyCellAction = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _react = _interopRequireWildcard(require("react"));
var _data_driven_columns = require("../../../timelines/components/timeline/body/data_driven_columns");
var _helpers = require("./helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCopyCellAction = ({
  data,
  pageSize,
  closeCellPopover
}) => data && data.length > 0 ? function CopyButton({
  rowIndex,
  columnId,
  Component
}) {
  const {
    timelines
  } = (0, _helpers.useKibanaServices)();
  const pageRowIndex = (0, _securitysolutionDataTable.getPageRowIndex)(rowIndex, pageSize);
  const copyButton = (0, _react.useMemo)(() => timelines.getHoverActions().getCopyButton, [timelines]);
  const rowData = (0, _react.useMemo)(() => {
    return {
      data: data[pageRowIndex],
      fieldName: columnId
    };
  }, [pageRowIndex, columnId]);
  const value = (0, _data_driven_columns.useGetMappedNonEcsValue)(rowData);
  const copyButtonProps = (0, _react.useMemo)(() => {
    return {
      Component,
      field: columnId,
      isHoverAction: false,
      ownFocus: false,
      showTooltip: false,
      value,
      onClick: closeCellPopover
    };
  }, [Component, columnId, value]);

  // data grid expects each cell action always return an element, it crashes if returns null
  return pageRowIndex >= data.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _helpers.EmptyComponent) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, copyButton(copyButtonProps));
} : _helpers.EmptyComponent;
exports.getCopyCellAction = getCopyCellAction;