"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddIntegrationsUrl = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../common/constants");
var _helpers = require("../../helpers");
var _utils = require("../components/utils");
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddIntegrationsUrl = () => {
  const {
    http: {
      basePath: {
        prepend
      }
    },
    cloudExperiments
  } = (0, _kibana.useKibana)().services;
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    navigateTo
  } = (0, _kibana.useNavigateTo)();
  const isThreatIntelligence = (0, _helpers.isThreatIntelligencePath)(pathname);
  const integrationsUrl = isThreatIntelligence ? _constants.ADD_THREAT_INTELLIGENCE_DATA_PATH : _constants.ADD_DATA_PATH;
  const [addIntegrationsUrl, setAddIntegrationsUrl] = (0, _react.useState)(integrationsUrl);
  (0, _utils.useVariation)(cloudExperiments, 'security-solutions.add-integrations-url', integrationsUrl, setAddIntegrationsUrl);
  const href = (0, _react.useMemo)(() => prepend(addIntegrationsUrl), [prepend, addIntegrationsUrl]);
  const onClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    navigateTo({
      url: href
    });
  }, [href, navigateTo]);
  return {
    href,
    onClick
  };
};
exports.useAddIntegrationsUrl = useAddIntegrationsUrl;