"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSourcererDataView = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _sourcerer = require("../../../../common/utils/sourcerer");
var _constants = require("../../../../common/constants");
var _get_sourcerer_data_view = require("./get_sourcerer_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSourcererDataView = async ({
  body,
  dataViewService,
  dataViewId
}) => {
  if (dataViewId === null) {
    return;
  }
  let allDataViews = await dataViewService.getIdsWithTitle();
  const siemDataViewExist = allDataViews.find(dv => dv.id === dataViewId);
  const {
    patternList
  } = body;
  const patternListAsTitle = (0, _sourcerer.ensurePatternFormat)(patternList).join();
  let siemDataView;
  if (siemDataViewExist === undefined) {
    try {
      siemDataView = await dataViewService.createAndSave({
        allowNoIndex: true,
        id: dataViewId,
        title: patternListAsTitle,
        timeFieldName: _constants.DEFAULT_TIME_FIELD
      },
      // Override property - if a data view exists with the security solution pattern
      // delete it and replace it with our data view
      true);
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      if (err.name === 'DuplicateDataViewError' || error.statusCode === 409) {
        siemDataView = await dataViewService.get(dataViewId);
      } else {
        throw error;
      }
    }
  } else {
    const siemDataViewTitle = siemDataViewExist ? (0, _sourcerer.ensurePatternFormat)(siemDataViewExist.title.split(',')).join() : '';
    siemDataView = await dataViewService.get(dataViewId);
    if (patternListAsTitle !== siemDataViewTitle) {
      siemDataView.title = patternListAsTitle;
      await dataViewService.updateSavedObject(siemDataView);
    }
  }
  if (allDataViews.some(dv => dv.id === dataViewId)) {
    allDataViews = allDataViews.map(v => v.id === dataViewId ? {
      ...v,
      title: patternListAsTitle
    } : v);
  } else if (siemDataView !== null) {
    var _siemDataView$id, _siemDataView;
    allDataViews.push({
      id: (_siemDataView$id = siemDataView.id) !== null && _siemDataView$id !== void 0 ? _siemDataView$id : dataViewId,
      title: (_siemDataView = siemDataView) === null || _siemDataView === void 0 ? void 0 : _siemDataView.title
    });
  }
  const siemSourcererDataView = await (0, _get_sourcerer_data_view.getSourcererDataView)(dataViewId, dataViewService);
  return {
    defaultDataView: siemSourcererDataView,
    kibanaDataViews: allDataViews.map(dv => dv.id === dataViewId ? siemSourcererDataView : {
      id: dv.id,
      patternList: dv.title.split(','),
      title: dv.title
    })
  };
};
exports.createSourcererDataView = createSourcererDataView;