"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_PROFILES_FAILURE = exports.UNKNOWN_USER_PROFILE_NAME = exports.CURRENT_USER_PROFILE_FAILURE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CURRENT_USER_PROFILE_FAILURE = _i18n.i18n.translate('xpack.securitySolution.userProfiles.fetchCurrentUserProfile.failure', {
  defaultMessage: 'Failed to find current user'
});
exports.CURRENT_USER_PROFILE_FAILURE = CURRENT_USER_PROFILE_FAILURE;
const USER_PROFILES_FAILURE = _i18n.i18n.translate('xpack.securitySolution.userProfiles.fetchUserProfiles.failure', {
  defaultMessage: 'Failed to find users'
});

/**
 * Used whenever we need to display a user name and for some reason it is not available
 */
exports.USER_PROFILES_FAILURE = USER_PROFILES_FAILURE;
const UNKNOWN_USER_PROFILE_NAME = _i18n.i18n.translate('xpack.securitySolution.userProfiles.unknownUser.displayName', {
  defaultMessage: 'Unknown'
});
exports.UNKNOWN_USER_PROFILE_NAME = UNKNOWN_USER_PROFILE_NAME;