"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextFieldValue = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const trimTextOverflow = (text, maxLength) => {
  if (maxLength !== undefined && text.length > maxLength) {
    return `${text.substr(0, maxLength)}...`;
  } else {
    return text;
  }
};
/*
 * Component to display text field value. Text field values can be large and need
 * programmatic truncation to a fixed text length. As text can be truncated the tooltip
 * is shown displaying the field name and full value. If the use case allows single
 * line truncation with CSS use eui-textTruncate class on this component instead of
 * maxLength property.
 */
const TextFieldValue = ({
  fieldName,
  value,
  maxLength,
  className
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorClassName: className,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      "data-test-subj": "dates-container",
      direction: "column",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, fieldName), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, value))
  }, /*#__PURE__*/_react.default.createElement("span", null, trimTextOverflow(value, maxLength)));
};
exports.TextFieldValue = TextFieldValue;