"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemporarySourcererComp = exports.TemporarySourcerer = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
var _update_default_data_view_modal = require("./update_default_data_view_modal");
var _types = require("../../../../common/types");
var _timeline = require("../../../../common/api/timeline");
var _timeline2 = require("../../../timelines/store/timeline");
var _use_selector = require("../../hooks/use_selector");
var _defaults = require("../../../timelines/store/timeline/defaults");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const translations = {
  deprecated: {
    title: {
      [_timeline.TimelineType.default]: i18n.CALL_OUT_DEPRECATED_TITLE,
      [_timeline.TimelineType.template]: i18n.CALL_OUT_DEPRECATED_TEMPLATE_TITLE
    },
    update: i18n.UPDATE_INDEX_PATTERNS
  },
  missingPatterns: {
    title: {
      [_timeline.TimelineType.default]: i18n.CALL_OUT_MISSING_PATTERNS_TITLE,
      [_timeline.TimelineType.template]: i18n.CALL_OUT_MISSING_PATTERNS_TEMPLATE_TITLE
    },
    update: i18n.ADD_INDEX_PATTERN
  }
};
const TemporarySourcererComp = /*#__PURE__*/_react.default.memo(({
  activePatterns,
  indicesExist,
  isModified,
  onDismiss,
  onReset,
  onUpdate,
  selectedPatterns,
  missingPatterns
}) => {
  const trigger = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "sourcerer-deprecated-update",
    fill: true,
    fullWidth: true,
    onClick: onUpdate,
    size: "s",
    disabled: !indicesExist
  }, translations[isModified].update), [indicesExist, isModified, onUpdate]);
  const buttonWithTooltip = (0, _react.useMemo)(() => !indicesExist ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18n.NO_DATA,
    "data-test-subj": "sourcerer-tooltip"
  }, trigger) : trigger, [indicesExist, trigger]);
  const deadPatterns = activePatterns && activePatterns.length > 0 ? selectedPatterns.filter(p => !activePatterns.includes(p)) : [];
  const getTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getTimelineByIdSelector(), []);
  const timelineType = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return ((_getTimeline = getTimeline(state, _types.TimelineId.active)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).timelineType;
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    "data-test-subj": "sourcerer-deprecated-callout",
    iconType: "warning",
    size: "s",
    title: translations[isModified].title[timelineType]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, activePatterns && activePatterns.length > 0 ? /*#__PURE__*/_react.default.createElement(_utils.CurrentPatternsMessage, {
    timelineType: timelineType,
    activePatterns: activePatterns,
    deadPatterns: deadPatterns,
    selectedPatterns: selectedPatterns
  }) : /*#__PURE__*/_react.default.createElement(_utils.BadCurrentPatternsMessage, {
    timelineType: timelineType,
    selectedPatterns: selectedPatterns
  }), isModified === 'deprecated' && /*#__PURE__*/_react.default.createElement(_utils.DeprecatedMessage, {
    timelineType: timelineType,
    onReset: onReset
  }), isModified === 'missingPatterns' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "sourcerer-missing-patterns-callout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.indexPatterns.missingPatterns.callout",
    defaultMessage: "Security Data View is missing the following index patterns: {callout}",
    values: {
      callout: /*#__PURE__*/_react.default.createElement(_helpers.Blockquote, null, missingPatterns.join(', '))
    }
  })), /*#__PURE__*/_react.default.createElement(_utils.MissingPatternsMessage, {
    timelineType: timelineType,
    onReset: onReset
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_helpers.ResetButton, {
    "aria-label": i18n.INDEX_PATTERNS_CLOSE,
    "data-test-subj": "sourcerer-deprecated-close",
    flush: "left",
    onClick: onDismiss,
    title: i18n.INDEX_PATTERNS_CLOSE
  }, i18n.INDEX_PATTERNS_CLOSE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, buttonWithTooltip)));
});
exports.TemporarySourcererComp = TemporarySourcererComp;
TemporarySourcererComp.displayName = 'TemporarySourcererComp';
const TemporarySourcerer = /*#__PURE__*/_react.default.memo(({
  activePatterns,
  indicesExist,
  isModified,
  missingPatterns,
  onContinueWithoutUpdate,
  onDismiss,
  onReset,
  onUpdateStepOne,
  onUpdateStepTwo,
  selectedPatterns,
  isShowingUpdateModal,
  onDismissModal
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TemporarySourcererComp, {
  activePatterns: activePatterns,
  indicesExist: indicesExist,
  isModified: isModified,
  missingPatterns: missingPatterns,
  onDismiss: onDismiss,
  onReset: onReset,
  onUpdate: onUpdateStepOne,
  selectedPatterns: selectedPatterns
}), /*#__PURE__*/_react.default.createElement(_update_default_data_view_modal.UpdateDefaultDataViewModal, {
  isShowing: isShowingUpdateModal,
  missingPatterns: missingPatterns,
  onDismissModal: onDismissModal,
  onContinue: onContinueWithoutUpdate,
  onUpdate: onUpdateStepTwo
})));
exports.TemporarySourcerer = TemporarySourcerer;
TemporarySourcerer.displayName = 'TemporarySourcerer';