"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityRoutePageWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/usage-collection-plugin/public");
var _links = require("../../links");
var _no_privileges = require("../no_privileges");
var _use_upselling = require("../../hooks/use_upselling");
var _spy_routes = require("../../utils/route/spy_routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component is created to wrap all the pages in the security solution app.
 *
 * It handles application tracking and upselling.
 *
 * When using this component make sure it render bellow `SecurityPageWrapper` and
 * that you removed the `TrackApplicationView` component.
 *
 * Ex:
 * ```
 * <PluginTemplateWrapper>
 *   <SecurityRoutePageWrapper pageName={SecurityPageName.myPage}>
 *     <MyPage />
 *   </SecurityRoutePageWrapper>
 * </PluginTemplateWrapper>
 * ```
 */
const SecurityRoutePageWrapper = ({
  children,
  pageName
}) => {
  const isAuthorized = (0, _links.useLinkAuthorized)(pageName);
  const UpsellPage = (0, _use_upselling.useUpsellingPage)(pageName);
  if (isAuthorized) {
    return /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
      viewId: pageName
    }, children);
  }
  if (UpsellPage) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
      pageName: pageName
    }), /*#__PURE__*/_react.default.createElement(UpsellPage, null));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: pageName
  }), /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivilegesPage, {
    pageName: pageName,
    docLinkSelector: docLinks => docLinks.siem.privileges
  }));
};
exports.SecurityRoutePageWrapper = SecurityRoutePageWrapper;