"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionsEmptyPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _translations = require("../../../detection_engine/rule_response_actions/osquery/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResponseActionsEmptyPrompt = ({
  type
}) => {
  const integration = (0, _react.useMemo)(() => {
    switch (type) {
      case 'endpoint':
        return {
          icon: 'logoSecurity',
          name: 'Elastic Defend'
        };
    }
  }, [type]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: integration.icon,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.PERMISSION_DENIED),
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.responseActions.results.missingPrivileges",
      defaultMessage: "To access these results, ask your administrator for {integration} Kibana privileges.",
      values: {
        integration: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, integration.name)
      }
    })
  });
};
exports.ResponseActionsEmptyPrompt = ResponseActionsEmptyPrompt;