"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoPrivilegesPage = exports.NoPrivileges = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _kibana = require("../../lib/kibana");
var _page_wrapper = require("../page_wrapper");
var _empty_page = require("../empty_page");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SizedEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-height: 460px;
  font-size: 1.1rem;
`;
const NoPrivilegesPage = /*#__PURE__*/_react.default.memo(({
  pageName,
  docLinkSelector
}) => /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(SizedEuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, null, /*#__PURE__*/_react.default.createElement(NoPrivileges, {
  pageName: pageName,
  docLinkSelector: docLinkSelector
}))))));
exports.NoPrivilegesPage = NoPrivilegesPage;
NoPrivilegesPage.displayName = 'NoPrivilegePage';
const NoPrivileges = /*#__PURE__*/_react.default.memo(({
  pageName,
  docLinkSelector
}) => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const emptyPageActions = (0, _react.useMemo)(() => ({
    feature: {
      icon: 'documents',
      label: i18n.GO_TO_DOCUMENTATION,
      url: docLinkSelector(docLinks.links),
      target: '_blank'
    }
  }), [docLinkSelector, docLinks.links]);
  const message = pageName ? i18n.NO_PRIVILEGES_PER_PAGE_MESSAGE(pageName) : i18n.NO_PRIVILEGES_DEFAULT_MESSAGE;
  return /*#__PURE__*/_react.default.createElement(_empty_page.EmptyPage, {
    actions: emptyPageActions,
    message: message,
    "data-test-subj": "noPrivilegesPage",
    title: i18n.NO_PERMISSIONS_TITLE
  });
});
exports.NoPrivileges = NoPrivileges;
NoPrivileges.displayName = 'NoPrivileges';