"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSecuritySolutionNavigation = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../lib/kibana");
var _breadcrumbs = require("../breadcrumbs");
var _security_side_nav = require("../security_side_nav");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const translatedNavTitle = _i18n.i18n.translate('xpack.securitySolution.navigation.mainLabel', {
  defaultMessage: 'Security'
});
const useSecuritySolutionNavigation = () => {
  const {
    sideNavEnabled
  } = (0, _kibana.useKibana)().services.configSettings;
  (0, _breadcrumbs.useBreadcrumbsNav)();
  if (!sideNavEnabled) {
    return undefined;
  }
  return {
    canBeCollapsed: true,
    name: translatedNavTitle,
    icon: 'logoSecurity',
    children: /*#__PURE__*/_react.default.createElement(_security_side_nav.SecuritySideNav, null),
    closeFlyoutButtonPosition: 'inside'
  };
};
exports.useSecuritySolutionNavigation = useSecuritySolutionNavigation;