"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySideNav = exports.EUI_HEADER_HEIGHT = exports.BOTTOM_BAR_HEIGHT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitySolutionSideNav = require("@kbn/security-solution-side-nav");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _types = require("../../../../app/types");
var _links = require("../../../links");
var _use_route_spy = require("../../../utils/route/use_route_spy");
var _links2 = require("../../links");
var _nav_links = require("../../../links/nav_links");
var _use_show_timeline = require("../../../utils/timeline/use_show_timeline");
var _policy_hooks = require("../../../../management/pages/policy/view/policy_hooks");
var _telemetry = require("../../../lib/telemetry");
var _kibana = require("../../../lib/kibana");
var _categories = require("./categories");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EUI_HEADER_HEIGHT = '93px';
exports.EUI_HEADER_HEIGHT = EUI_HEADER_HEIGHT;
const BOTTOM_BAR_HEIGHT = '50px';
exports.BOTTOM_BAR_HEIGHT = BOTTOM_BAR_HEIGHT;
const getNavItemPosition = id => id === _types.SecurityPageName.landing || id === _types.SecurityPageName.administration ? _securitySolutionSideNav.SolutionSideNavItemPosition.bottom : _securitySolutionSideNav.SolutionSideNavItemPosition.top;
const isGetStartedNavItem = id => id === _types.SecurityPageName.landing;

/**
 * Formats generic navigation links into the shape expected by the `SolutionSideNav`
 */
const formatLink = (navLink, getSecuritySolutionLinkProps) => {
  var _navLink$categories, _navLink$links;
  return {
    id: navLink.id,
    label: navLink.title,
    position: getNavItemPosition(navLink.id),
    ...getSecuritySolutionLinkProps({
      deepLinkId: navLink.id
    }),
    ...(navLink.sideNavIcon && {
      iconType: navLink.sideNavIcon
    }),
    ...(((_navLink$categories = navLink.categories) === null || _navLink$categories === void 0 ? void 0 : _navLink$categories.length) && {
      categories: navLink.categories
    }),
    ...(((_navLink$links = navLink.links) === null || _navLink$links === void 0 ? void 0 : _navLink$links.length) && {
      items: navLink.links.reduce((acc, current) => {
        if (!current.disabled) {
          acc.push({
            id: current.id,
            label: current.title,
            iconType: current.sideNavIcon,
            isBeta: current.isBeta,
            betaOptions: current.betaOptions,
            ...getSecuritySolutionLinkProps({
              deepLinkId: current.id
            })
          });
        }
        return acc;
      }, [])
    })
  };
};

/**
 * Formats the get started navigation links into the shape expected by the `SolutionSideNav`
 */
const formatGetStartedLink = (navLink, getSecuritySolutionLinkProps) => ({
  id: navLink.id,
  label: navLink.title,
  iconType: navLink.sideNavIcon,
  position: _securitySolutionSideNav.SolutionSideNavItemPosition.bottom,
  appendSeparator: true,
  ...getSecuritySolutionLinkProps({
    deepLinkId: navLink.id
  })
});

/**
 * Returns the formatted `items` and `footerItems` to be rendered in the navigation
 */
const useSolutionSideNavItems = () => {
  const navLinks = (0, _nav_links.useNavLinks)();
  const getSecuritySolutionLinkProps = (0, _links2.useGetSecuritySolutionLinkProps)(); // adds href and onClick props

  const sideNavItems = (0, _react.useMemo)(() => {
    if (!(navLinks !== null && navLinks !== void 0 && navLinks.length)) {
      return undefined;
    }
    return navLinks.reduce((navItems, navLink) => {
      if (navLink.disabled) {
        return navItems;
      }
      if (isGetStartedNavItem(navLink.id)) {
        navItems.push(formatGetStartedLink(navLink, getSecuritySolutionLinkProps));
      } else {
        navItems.push(formatLink(navLink, getSecuritySolutionLinkProps));
      }
      return navItems;
    }, []);
  }, [navLinks, getSecuritySolutionLinkProps]);
  return sideNavItems;
};
const useSelectedId = () => {
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const selectedId = (0, _react.useMemo)(() => {
    var _rootLinkInfo$id;
    const [rootLinkInfo] = (0, _links.getAncestorLinksInfo)(pageName);
    return (_rootLinkInfo$id = rootLinkInfo === null || rootLinkInfo === void 0 ? void 0 : rootLinkInfo.id) !== null && _rootLinkInfo$id !== void 0 ? _rootLinkInfo$id : '';
  }, [pageName]);
  return selectedId;
};
const usePanelTopOffset = () => {
  const {
    chrome: {
      hasHeaderBanner$
    }
  } = (0, _kibana.useKibana)().services;
  const hasHeaderBanner = (0, _useObservable.default)(hasHeaderBanner$());
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return hasHeaderBanner ? `calc(${EUI_HEADER_HEIGHT} + ${euiTheme.size.xl})` : undefined;
};
const usePanelBottomOffset = () => {
  const isPolicySettingsVisible = (0, _policy_hooks.useIsPolicySettingsBarVisible)();
  const [isTimelineBottomBarVisible] = (0, _use_show_timeline.useShowTimeline)();
  return isTimelineBottomBarVisible || isPolicySettingsVisible ? BOTTOM_BAR_HEIGHT : undefined;
};

/**
 * Main security navigation component.
 * It takes the links to render from the generic application `links` configs.
 */
const SecuritySideNav = () => {
  const items = useSolutionSideNavItems();
  const selectedId = useSelectedId();
  const panelTopOffset = usePanelTopOffset();
  const panelBottomOffset = usePanelBottomOffset();
  if (!items) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "data-test-subj": "sideNavLoader"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_securitySolutionSideNav.SolutionSideNav, {
    items: items,
    categories: _categories.CATEGORIES,
    selectedId: selectedId,
    panelTopOffset: panelTopOffset,
    panelBottomOffset: panelBottomOffset,
    tracker: _telemetry.track
  });
};
exports.SecuritySideNav = SecuritySideNav;